/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.command.impl.mail.MarkDeleteMessageCommand;
import net.sf.amemailchecker.db.DefaultDAOFactory;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.dao.LetterDAO;
import net.sf.amemailchecker.gui.component.table.SelectionMode;
import net.sf.amemailchecker.gui.messageviewer.extension.action.FolderDeleteLocalAction;
import net.sf.amemailchecker.gui.messageviewer.extension.action.MarkAction;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.FolderType;
import net.sf.amemailchecker.mail.model.Letter;

public class MarkDeleteAction
extends MarkAction {
    private static final Logger logger = Logger.getLogger(FolderDeleteLocalAction.class.getName());

    public MarkDeleteAction(MessageViewerContext messageViewerContext) {
        super(messageViewerContext);
    }

    public MarkDeleteAction(String string, MessageViewerContext messageViewerContext, SelectionMode selectionMode) {
        super(string, messageViewerContext, selectionMode);
    }

    public void performMarkDeleteAction(Account account, Folder folder, Letter ... letterArray) {
        if (letterArray == null || letterArray.length == 0) {
            return;
        }
        this.update(letterArray);
        if (folder.getType().equals((Object)FolderType.REMOTE)) {
            this.executeMark(new MarkDeleteMessageCommand(account, folder, letterArray), letterArray);
        } else {
            this.onLocal(letterArray, folder);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.performMarkDeleteAction(this.context.getAccount(), this.context.getFolder(), this.letters(this.mode, true));
    }

    private void onLocal(Letter[] letterArray, Folder folder) {
        LetterDAO letterDAO = DefaultDAOFactory.getInstance().getLetterDAO();
        for (Letter letter : letterArray) {
            try {
                letterDAO.delete(letter, folder);
            }
            catch (DataBaseNegotiationException dataBaseNegotiationException) {
                logger.log(Level.INFO, "Unable to delete local letter " + letter.getMessageID() + " for folder " + folder.getName());
                logger.log(Level.SEVERE, dataBaseNegotiationException.getMessage(), dataBaseNegotiationException);
            }
        }
    }
}

