/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.db.DefaultDAOFactory;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.db.dao.LetterDAO;
import net.sf.amemailchecker.gui.component.table.SelectionMode;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.gui.messageviewer.extension.action.CopyLettersLocalAction;
import net.sf.amemailchecker.mail.model.Letter;

public class MoveLettersLocalAction
extends CopyLettersLocalAction {
    private static final Logger logger = Logger.getLogger(MoveLettersLocalAction.class.getName());

    public MoveLettersLocalAction(String string, MessageViewerContext messageViewerContext, SelectionMode selectionMode) {
        super(string, messageViewerContext, selectionMode);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.performAction(this.letters(this.mode, true));
    }

    @Override
    protected void listener(Letter[] letterArray) {
        LetterDAO letterDAO = DefaultDAOFactory.getInstance().getLetterDAO();
        for (Letter letter : letterArray) {
            try {
                if (!letterDAO.contains(this.to, letter)) {
                    letterDAO.move(letter, this.context.getFolder(), this.to);
                    continue;
                }
                letterDAO.delete(letter, this.context.getFolder());
            }
            catch (DataBaseNegotiationException dataBaseNegotiationException) {
                logger.log(Level.INFO, "Unable to move letter " + letter.getUid() + "to folder" + this.to);
                logger.log(Level.SEVERE, dataBaseNegotiationException.getMessage(), dataBaseNegotiationException);
            }
        }
        MessageViewer.Viewer.getContext().getFolderTree().getLocalFolderTree(this.context.getAccount()).refresh();
    }

    @Override
    public boolean isEnabled() {
        switch (this.mode) {
            case CHECKED: {
                return this.context.getLettersTable().getChecked(false).length > 0;
            }
            case SELECTED: {
                return this.context.getLettersTable().hasSelection();
            }
        }
        return !this.context.getLettersTable().empty();
    }
}

