/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.action;

import java.awt.Window;
import javax.swing.JOptionPane;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.command.CommandExecutionListener;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.impl.mail.SendMessageCommand;
import net.sf.amemailchecker.command.task.CommandExecutable;
import net.sf.amemailchecker.command.task.NotificationBlockUITask;
import net.sf.amemailchecker.gui.notification.NotificationType;
import net.sf.amemailchecker.gui.notification.NotificationWindowFactory;
import net.sf.amemailchecker.gui.notification.window.modal.IModalNotificationWindow;
import net.sf.amemailchecker.mail.cache.PostalAddresseeCache;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Addressee;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.mail.model.PostalAddressee;

public class SendAction {
    public void performSendAction(Account account, Letter letter, final Window window) {
        Object object;
        Addressee addressee;
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        if (account == null || !account.isActive()) {
            if (applicationContext.getAccountsCache().isEmpty()) {
                IModalNotificationWindow iModalNotificationWindow = NotificationWindowFactory.getSystemNotificationWindow(applicationContext.getI18NBundleValue("message.no.accounts"), window);
                iModalNotificationWindow.showNotification(NotificationType.ERROR);
                return;
            }
            addressee = applicationContext.getAccountsCache().getAccountNames(false);
            if (((String[])addressee).length == 1) {
                object = addressee[0];
            } else {
                object = (String)JOptionPane.showInputDialog(window, applicationContext.getI18NBundleValue("message.select.account"), applicationContext.getI18NBundleValue("dialog.account.selection.title"), -1, null, (Object[])addressee, addressee[0]);
                if (object == null) {
                    return;
                }
            }
            account = applicationContext.getAccountsCache().getByTitle((String)object);
        }
        if ((addressee = PostalAddresseeCache.Instance.findByAddress(account.getEmailAddress())) == null) {
            addressee = new Addressee(applicationContext.getUserData().getPersonalData().getPersonIdentity().toString(), account.getEmailAddress());
        }
        ((LetterImpl)letter).setSender((PostalAddressee)addressee);
        object = new SendMessageCommand(account, letter);
        NotificationBlockUITask notificationBlockUITask = new NotificationBlockUITask((ICommand)object, window);
        notificationBlockUITask.addCommandExecutionListener(new CommandExecutionListener(){

            public void beforeExecution(CommandExecutable commandExecutable) {
            }

            public void afterExecution(CommandExecutable commandExecutable) {
                if (commandExecutable.isExecutionPerformed() && commandExecutable.getException() == null) {
                    window.setVisible(false);
                }
            }
        });
        CommandExecutionService.Service.executeNotify(notificationBlockUITask);
    }
}

