/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.point;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.app.extension.MailActionContext;
import net.sf.amemailchecker.app.extension.MailActionContextChangeListener;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.app.extension.viewer.ViewerExtensionPoint;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.messageviewer.extension.action.FolderCreateAction;
import net.sf.amemailchecker.gui.messageviewer.extension.action.FolderCreateLocalAction;
import net.sf.amemailchecker.gui.messageviewer.extension.action.FolderDeleteAction;
import net.sf.amemailchecker.gui.messageviewer.extension.action.FolderDeleteLocalAction;
import net.sf.amemailchecker.gui.messageviewer.extension.action.FolderRenameAction;
import net.sf.amemailchecker.gui.messageviewer.extension.action.FolderRenameLocalAction;
import net.sf.amemailchecker.gui.messageviewer.extension.action.ReplyAction;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageDetailsEditState;
import net.sf.amemailchecker.mail.Protocol;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.FolderType;

public class MessageViewerExtensionPoint
implements ViewerExtensionPoint {
    public AbstractButton[] controls(MessageViewerContext messageViewerContext) {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        JButton jButton = ActionControlFactory.Factory.constructActionPanelButton(applicationContext.getI18NBundleValue("action.compose.new.label"), applicationContext.loadImageIcon("icon.action.compose.new"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ReplyAction().performReplyAction(new LetterImpl(), MessageDetailsEditState.COMPOSE_NEW);
            }
        });
        return new AbstractButton[]{jButton};
    }

    public Action[] onFolder(MessageViewerContext messageViewerContext, MailActionContext mailActionContext) {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        switch (mailActionContext.getFolder().getType()) {
            case LOCAL: {
                return this.onFolderLocal(applicationContext, mailActionContext);
            }
            case REMOTE: {
                return this.onFolderRemote(applicationContext, mailActionContext);
            }
        }
        return null;
    }

    private Action[] onFolderRemote(ResourceContext resourceContext, MailActionContext mailActionContext) {
        return new AbstractAction[]{new FolderCreateAction(resourceContext.getI18NBundleValue("action.new.label"), mailActionContext), new FolderDeleteAction(resourceContext.getI18NBundleValue("action.delete.label"), mailActionContext), new FolderRenameAction(resourceContext.getI18NBundleValue("action.rename.label"), mailActionContext)};
    }

    private Action[] onFolderLocal(ResourceContext resourceContext, MailActionContext mailActionContext) {
        return new AbstractAction[]{new FolderCreateLocalAction(resourceContext.getI18NBundleValue("action.new.label"), mailActionContext), new FolderDeleteLocalAction(resourceContext.getI18NBundleValue("action.delete.label"), mailActionContext), new FolderRenameLocalAction(resourceContext.getI18NBundleValue("action.rename.label"), mailActionContext)};
    }

    public JMenu menu(MailActionContext mailActionContext) {
        Folder folder = mailActionContext.getFolder();
        return mailActionContext.getAccount().getIncomingServerProtocol().equals((Object)Protocol.POP3) && folder != null && folder.getType().equals((Object)FolderType.REMOTE) ? null : new JMenu(ApplicationContext.getInstance().getI18NBundleValue("label.folders"));
    }

    public Action[] onAccount(MessageViewerContext messageViewerContext, MailActionContext mailActionContext) {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        return new AbstractAction[]{new FolderCreateAction(applicationContext.getI18NBundleValue("action.create.folder.remote"), mailActionContext), new FolderCreateLocalAction(applicationContext.getI18NBundleValue("action.create.folder.local"), mailActionContext)};
    }

    public Action[] onFolderTree(MessageViewerContext messageViewerContext, MailActionContext mailActionContext, FolderType folderType) {
        switch (folderType) {
            case LOCAL: {
                return this.onFolderTreeLocal(mailActionContext);
            }
            case REMOTE: {
                return this.onFolderTreeRemote(mailActionContext);
            }
        }
        return new Action[0];
    }

    private Action[] onFolderTreeLocal(MailActionContext mailActionContext) {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        return new AbstractAction[]{new FolderCreateLocalAction(applicationContext.getI18NBundleValue("action.create.folder"), mailActionContext)};
    }

    private Action[] onFolderTreeRemote(MailActionContext mailActionContext) {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        return new AbstractAction[]{new FolderCreateAction(applicationContext.getI18NBundleValue("action.create.folder"), mailActionContext)};
    }

    public MailActionContextChangeListener listener() {
        return null;
    }

    public Map<KeyStroke, Action> onLetter(MessageViewerContext messageViewerContext) {
        return null;
    }

    public Action[] onLetter(MessageViewerContext messageViewerContext, MailActionContext mailActionContext) {
        return null;
    }
}

