/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.extension.point;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsActionContext;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsActionExtensionPoint;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsChangeListener;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.impl.app.SaveAttachmentMultipleCommand;
import net.sf.amemailchecker.command.task.DefaultCommandExecutableTask;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.component.button.DropDownMenuButton;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.gui.messageviewer.extension.action.FetchAction;
import net.sf.amemailchecker.gui.messageviewer.extension.action.MarkAsReadAction;
import net.sf.amemailchecker.gui.messageviewer.extension.action.MarkDeleteAction;
import net.sf.amemailchecker.gui.messageviewer.extension.action.ReplyAction;
import net.sf.amemailchecker.gui.messageviewer.extension.action.SendAction;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageDetailsEditState;
import net.sf.amemailchecker.mail.model.Attachment;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.FolderType;
import net.sf.amemailchecker.mail.model.Letter;

public class MessageViewerLetterDetailsExtensionPoint
implements LetterDetailsActionExtensionPoint {
    public AbstractButton[] action(final LetterDetailsActionContext letterDetailsActionContext, LetterDetailsActionExtensionPoint.State state) {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        ActionControlFactory actionControlFactory = ActionControlFactory.Factory;
        DropDownMenuButton dropDownMenuButton = (DropDownMenuButton)actionControlFactory.constructActionPanelButton((AbstractButton)new DropDownMenuButton(false), applicationContext.getI18NBundleValue("label.attachments"), applicationContext.loadImageIcon("icon.attachment"));
        if (state.equals((Object)LetterDetailsActionExtensionPoint.State.EDIT)) {
            JButton jButton = actionControlFactory.constructActionPanelButton(applicationContext.getI18NBundleValue("action.send.label"), applicationContext.loadImageIcon("icon.action.send"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new SendAction().performSendAction(letterDetailsActionContext.getModel().getAccount(), (Letter)letterDetailsActionContext.getModel().acceptChanges(), letterDetailsActionContext.getOwner());
                }
            });
            JMenu jMenu = new JMenu();
            jMenu.add(ActionControlFactory.Factory.getJMenuItem(applicationContext.getI18NBundleValue("action.attach.insert"), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File[] fileArray;
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setSelectedFile(new File(System.getProperty("user.home")));
                    jFileChooser.setMultiSelectionEnabled(true);
                    int n = jFileChooser.showOpenDialog(letterDetailsActionContext.getOwner());
                    if (n != 0) {
                        return;
                    }
                    for (File file : fileArray = jFileChooser.getSelectedFiles()) {
                        Attachment attachment = new Attachment();
                        attachment.setFile(file);
                        attachment.setName(file.getName());
                        letterDetailsActionContext.getModel().insertAttachment(attachment);
                    }
                }
            }));
            jMenu.addSeparator();
            jMenu.add(ActionControlFactory.Factory.getJMenuItem(applicationContext.getI18NBundleValue("action.attach.delete.all"), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ArrayList arrayList = new ArrayList(letterDetailsActionContext.getModel().getAttachments());
                    for (Attachment attachment : arrayList) {
                        letterDetailsActionContext.getModel().removeAttachment(attachment);
                    }
                }
            }));
            dropDownMenuButton.setPopupMenu(jMenu.getPopupMenu());
            return new AbstractButton[]{jButton, dropDownMenuButton};
        }
        JMenu jMenu = new JMenu();
        jMenu.add(ActionControlFactory.Factory.getJMenuItem(applicationContext.getI18NBundleValue("action.attach.save.all"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(ApplicationContext.getInstance().getUserData().getPreferences().getDownloadsDirPath());
                CommandExecutionService.Service.executeNotify(new DefaultCommandExecutableTask(new SaveAttachmentMultipleCommand(file, letterDetailsActionContext.getModel().getAttachments())));
            }
        }));
        jMenu.add(ActionControlFactory.Factory.getJMenuItem(applicationContext.getI18NBundleValue("action.attach.save.as.all"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setSelectedFile(new File(System.getProperty("user.home")));
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showSaveDialog(letterDetailsActionContext.getOwner());
                if (n != 0) {
                    return;
                }
                CommandExecutionService.Service.executeNotify(new DefaultCommandExecutableTask(new SaveAttachmentMultipleCommand(jFileChooser.getSelectedFile(), letterDetailsActionContext.getModel().getAttachments())));
            }
        }));
        dropDownMenuButton.setPopupMenu(jMenu.getPopupMenu());
        final JButton jButton = actionControlFactory.constructActionPanelButton(applicationContext.getI18NBundleValue("action.download.label"), applicationContext.loadImageIcon("icon.action.download"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new FetchAction(MessageViewer.Viewer.getContext()).performFetchAction(letterDetailsActionContext.getModel().getAccount(), MessageViewer.Viewer.getContext().getFolder(), letterDetailsActionContext.getModel().getLetter());
                jButton.setEnabled(false);
            }
        });
        JButton jButton2 = actionControlFactory.constructActionPanelButton(applicationContext.getI18NBundleValue("action.mark.as.read.label"), applicationContext.loadImageIcon("icon.action.mark.as.read"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Letter letter = letterDetailsActionContext.getModel().getLetter();
                MessageViewer.Viewer.getContext().getLettersTable().remove(letter);
                MessageViewer.Viewer.getContext().getLettersTabbedPane().remove(new Letter[]{letter});
                new MarkAsReadAction(MessageViewer.Viewer.getContext()).performMarkAsReadAction(letterDetailsActionContext.getModel().getAccount(), MessageViewer.Viewer.getContext().getFolder(), letterDetailsActionContext.getModel().getLetter());
            }
        });
        JButton jButton3 = actionControlFactory.constructActionPanelButton(applicationContext.getI18NBundleValue("action.delete.label"), applicationContext.loadImageIcon("icon.action.delete"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MessageViewer.Viewer.getContext().getLettersTable().remove(letterDetailsActionContext.getModel().getLetter());
                MessageViewer.Viewer.getContext().getLettersTabbedPane().remove(new Letter[]{letterDetailsActionContext.getModel().getLetter()});
                new MarkDeleteAction(MessageViewer.Viewer.getContext()).performMarkDeleteAction(letterDetailsActionContext.getModel().getAccount(), MessageViewer.Viewer.getContext().getFolder(), letterDetailsActionContext.getModel().getLetter());
            }
        });
        DropDownMenuButton dropDownMenuButton2 = (DropDownMenuButton)actionControlFactory.constructActionPanelButton((AbstractButton)new DropDownMenuButton(true), applicationContext.getI18NBundleValue("action.reply.label"), applicationContext.loadImageIcon("icon.action.reply"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ReplyAction().performReplyAction(letterDetailsActionContext.getModel().getLetter(), MessageDetailsEditState.REPLY);
            }
        };
        dropDownMenuButton2.addActionListener(actionListener);
        JMenu jMenu2 = new JMenu();
        JMenuItem jMenuItem = new JMenuItem(applicationContext.getI18NBundleValue("action.reply.label"));
        jMenuItem.addActionListener(actionListener);
        JMenuItem jMenuItem2 = new JMenuItem(applicationContext.getI18NBundleValue("action.reply.all.label"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ReplyAction().performReplyAction(letterDetailsActionContext.getModel().getLetter(), MessageDetailsEditState.REPLY_ALL);
            }
        });
        jMenu2.add(jMenuItem);
        jMenu2.add(jMenuItem2);
        dropDownMenuButton2.setPopupMenu(jMenu2.getPopupMenu());
        JButton jButton4 = actionControlFactory.constructActionPanelButton(applicationContext.getI18NBundleValue("action.forward.label"), applicationContext.loadImageIcon("icon.action.forward"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ReplyAction().performReplyAction(letterDetailsActionContext.getModel().getLetter(), MessageDetailsEditState.FORWARD);
            }
        });
        return new AbstractButton[]{jButton, jButton2, jButton3, jButton4, dropDownMenuButton2, dropDownMenuButton};
    }

    public boolean containsActions(LetterDetailsActionExtensionPoint.State state) {
        return true;
    }

    public LetterDetailsChangeListener letterChangeListener() {
        return new LetterDetailsChangeListener(){

            public void letterDetailsChanged(Folder folder, Letter letter, AbstractButton[] abstractButtonArray) {
                boolean bl = folder.getType().equals((Object)FolderType.REMOTE);
                abstractButtonArray[0].setEnabled(!letter.isFetched() && bl);
                abstractButtonArray[1].setEnabled(bl);
                boolean bl2 = letter.hasTexts();
                abstractButtonArray[3].setEnabled(bl2);
                abstractButtonArray[4].setEnabled(bl2);
                abstractButtonArray[5].setEnabled(letter.hasAttachments());
            }
        };
    }
}

