/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.foldertree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionListener;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.DefaultMailActionContext;
import net.sf.amemailchecker.app.extension.ExtensionProvider;
import net.sf.amemailchecker.app.extension.MailActionContext;
import net.sf.amemailchecker.app.extension.viewer.FolderTree;
import net.sf.amemailchecker.app.extension.viewer.FolderTreeMediator;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.app.extension.viewer.ViewerExtensionPoint;
import net.sf.amemailchecker.gui.component.accordion.AccordionBar;
import net.sf.amemailchecker.gui.component.container.TitledPanel;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.gui.messageviewer.foldertree.AccountExtensionMouseListener;
import net.sf.amemailchecker.gui.messageviewer.foldertree.LocalFolderTreeMediatorProxy;
import net.sf.amemailchecker.gui.messageviewer.foldertree.RemoteFolderTreeMediatorProxy;
import net.sf.amemailchecker.mail.Protocol;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.FolderType;

public class DefaultFolderTreeMediator
implements FolderTreeMediator {
    private AccordionBar accountAccordion;
    private Map<FolderType, EventListenerList> folderChangeListeners = new HashMap<FolderType, EventListenerList>();
    private Map<String, FolderTreeMediatorCacheItem> cache;

    public DefaultFolderTreeMediator() {
        this.folderChangeListeners.put(FolderType.LOCAL, new EventListenerList());
        this.folderChangeListeners.put(FolderType.REMOTE, new EventListenerList());
        this.cache = new TreeMap<String, FolderTreeMediatorCacheItem>();
    }

    public void addFolderChangeListener(FolderType folderType, MouseListener mouseListener) {
        this.folderChangeListeners.get(folderType).add(MouseListener.class, mouseListener);
    }

    public void addFolderTreeSelectionChangeListener(FolderType folderType, TreeSelectionListener treeSelectionListener) {
        this.folderChangeListeners.get(folderType).add(TreeSelectionListener.class, treeSelectionListener);
    }

    public synchronized AccordionBar component() {
        if (this.accountAccordion != null) {
            return this.accountAccordion;
        }
        this.accountAccordion = new AccordionBar();
        this.accountAccordion.setPreferredSize(new Dimension(200, this.accountAccordion.getPreferredSize().height));
        this.accountAccordion.addHeaderMouseListener((MouseListener)new AccountExtensionMouseListener());
        return this.accountAccordion;
    }

    public void select(Account account, Folder folder) {
        FolderTree folderTree = folder.getType().equals((Object)FolderType.LOCAL) ? this.getRemoteFolderTree(account) : this.getLocalFolderTree(account);
        folderTree.clearSelection();
    }

    public void refresh(Account account) {
        this.getLocalFolderTree(account).refresh();
        this.getRemoteFolderTree(account).refresh();
    }

    public FolderTree getLocalFolderTree(Account account) {
        return this.cache.get(account.getUuid()).getLocalTree();
    }

    public FolderTree getRemoteFolderTree(Account account) {
        return this.cache.get(account.getUuid()).getRemoteTree();
    }

    public void setSelectedAccount(Account account) {
        this.accountAccordion.setVisibleBar(account.getUuid());
    }

    public Account getSelectedAccount() {
        return ApplicationContext.getInstance().getAccountsCache().getByUuid(this.accountAccordion.getVisibleBarInfo().getName());
    }

    public boolean contains(Account account) {
        return this.accountAccordion.containsBar(account.getUuid());
    }

    public void insert(Account account) {
        RemoteFolderTreeMediatorProxy remoteFolderTreeMediatorProxy = new RemoteFolderTreeMediatorProxy();
        JTree jTree = remoteFolderTreeMediatorProxy.folderTree(account);
        this.listeners(FolderType.REMOTE, jTree);
        LocalFolderTreeMediatorProxy localFolderTreeMediatorProxy = new LocalFolderTreeMediatorProxy();
        JTree jTree2 = localFolderTreeMediatorProxy.folderTree(account);
        this.listeners(FolderType.LOCAL, jTree2);
        FolderTreeMediatorCacheItem folderTreeMediatorCacheItem = new FolderTreeMediatorCacheItem();
        folderTreeMediatorCacheItem.setLocalTree(localFolderTreeMediatorProxy);
        folderTreeMediatorCacheItem.setRemoteTree(remoteFolderTreeMediatorProxy);
        this.cache.put(account.getUuid(), folderTreeMediatorCacheItem);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(this.treePanel(ApplicationContext.getInstance().getI18NBundleValue("label.remote"), jTree, FolderType.REMOTE, account.getIncomingServerProtocol().getId() != Protocol.POP3.getId()));
        jPanel.add(this.treePanel(ApplicationContext.getInstance().getI18NBundleValue("label.local"), jTree2, FolderType.LOCAL, true));
        this.accountAccordion.addBar(account.getUuid(), account.getTitle(), (JComponent)jPanel);
    }

    private void listeners(FolderType folderType, JTree jTree) {
        for (TreeSelectionListener eventListener : (TreeSelectionListener[])this.folderChangeListeners.get(folderType).getListeners(TreeSelectionListener.class)) {
            jTree.addTreeSelectionListener(eventListener);
        }
        for (EventListener eventListener : (MouseListener[])this.folderChangeListeners.get(folderType).getListeners(MouseListener.class)) {
            jTree.addMouseListener((MouseListener)eventListener);
        }
    }

    JPanel treePanel(String string, JTree jTree, FolderType folderType, boolean bl) {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jTree);
        TitledPanel titledPanel = new TitledPanel(string);
        titledPanel.setDrawActionStrip(bl);
        titledPanel.setLayout((LayoutManager)new BorderLayout());
        titledPanel.add((Component)jScrollPane, (Object)"Center");
        titledPanel.addActionListener((ActionListener)new FolderTreeActionListener(titledPanel, folderType));
        return titledPanel;
    }

    public void update(Account account) {
        this.accountAccordion.updateBar(account.getUuid(), account.getTitle());
        this.getRemoteFolderTree(account).update(account);
        this.getLocalFolderTree(account).update(account);
    }

    public void remove(Account account) {
        this.accountAccordion.removeBar(account.getUuid());
        this.cache.remove(account.getUuid());
    }

    public int size() {
        return this.accountAccordion.count();
    }

    private class FolderTreeActionListener
    implements ActionListener {
        private TitledPanel panel;
        private FolderType type;

        private FolderTreeActionListener(TitledPanel titledPanel, FolderType folderType) {
            this.panel = titledPanel;
            this.type = folderType;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.panel.removeActions();
            List<ViewerExtensionPoint> list = ExtensionProvider.Provider.getViewerExtensionPoints();
            MessageViewerContext messageViewerContext = MessageViewer.Viewer.getContext();
            DefaultMailActionContext defaultMailActionContext = new DefaultMailActionContext();
            defaultMailActionContext.setAccount(MessageViewer.Viewer.getContext().getAccount());
            for (ViewerExtensionPoint viewerExtensionPoint : list) {
                Action[] actionArray = viewerExtensionPoint.onFolderTree(messageViewerContext, (MailActionContext)defaultMailActionContext, this.type);
                if (actionArray == null || actionArray.length <= 0) continue;
                for (Action action : actionArray) {
                    if (!action.isEnabled()) continue;
                    this.panel.addAction(action);
                }
            }
        }
    }

    private static class FolderTreeMediatorCacheItem {
        private RemoteFolderTreeMediatorProxy remoteTree;
        private LocalFolderTreeMediatorProxy localTree;

        private FolderTreeMediatorCacheItem() {
        }

        public RemoteFolderTreeMediatorProxy getRemoteTree() {
            return this.remoteTree;
        }

        public void setRemoteTree(RemoteFolderTreeMediatorProxy remoteFolderTreeMediatorProxy) {
            this.remoteTree = remoteFolderTreeMediatorProxy;
        }

        public LocalFolderTreeMediatorProxy getLocalTree() {
            return this.localTree;
        }

        public void setLocalTree(LocalFolderTreeMediatorProxy localFolderTreeMediatorProxy) {
            this.localTree = localFolderTreeMediatorProxy;
        }
    }
}

