/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.foldertree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import net.sf.amemailchecker.app.extension.DefaultMailActionContext;
import net.sf.amemailchecker.app.extension.ExtensionProvider;
import net.sf.amemailchecker.app.extension.MailActionContext;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.app.extension.viewer.ViewerExtensionPoint;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;

public class FolderTreeExtensionMouseListener
extends MouseAdapter {
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        JTree jTree = (JTree)mouseEvent.getComponent();
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        TreePath treePath2 = jTree.getSelectionPath();
        if (treePath == null || treePath2 == null || !treePath2.equals(treePath)) {
            return;
        }
        List<ViewerExtensionPoint> list = ExtensionProvider.Provider.getViewerExtensionPoints();
        MessageViewerContext messageViewerContext = MessageViewer.Viewer.getContext();
        DefaultMailActionContext defaultMailActionContext = new DefaultMailActionContext();
        defaultMailActionContext.setAccount(MessageViewer.Viewer.getContext().getAccount());
        defaultMailActionContext.setFolder(MessageViewer.Viewer.getContext().getFolder());
        if (mouseEvent.getButton() == 3) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            int n = 0;
            for (ViewerExtensionPoint viewerExtensionPoint : list) {
                Action[] actionArray = viewerExtensionPoint.onFolder(messageViewerContext, (MailActionContext)defaultMailActionContext);
                JMenu jMenu = viewerExtensionPoint.menu((MailActionContext)defaultMailActionContext);
                if (actionArray == null || actionArray.length <= 0) continue;
                if (jMenu != null) {
                    for (Action action : actionArray) {
                        jMenu.add(new JMenuItem(action));
                    }
                    jPopupMenu.add(jMenu);
                    continue;
                }
                if (n > 0) {
                    jPopupMenu.add(new JSeparator(0));
                }
                boolean bl = false;
                for (Action action : actionArray) {
                    if (!action.isEnabled()) continue;
                    jPopupMenu.add(new JMenuItem(action));
                    bl = true;
                }
                if (!bl) continue;
                ++n;
            }
            if (jPopupMenu.getComponentCount() <= 0) {
                return;
            }
            jPopupMenu.show(jTree, mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

