/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.foldertree;

import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sf.amemailchecker.app.extension.viewer.FolderTree;
import net.sf.amemailchecker.gui.component.tree.CheckedValueTreeModel;
import net.sf.amemailchecker.gui.component.tree.TreeModelHierarchyIterator;
import net.sf.amemailchecker.gui.messageviewer.foldertree.FolderCellLabelBuilder;
import net.sf.amemailchecker.gui.messageviewer.foldertree.FolderTreeExtensionMouseListener;
import net.sf.amemailchecker.gui.messageviewer.foldertree.FolderTreeModelHierarchyIterator;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;

abstract class FolderTreeMediatorProxy
implements FolderTree {
    protected JTree folderTree;
    protected CheckedValueTreeModel<Folder> folderTreeModel;

    FolderTreeMediatorProxy() {
    }

    abstract JTree folderTree(Account var1);

    public void insert(Folder folder, Folder folder2) {
        this.folderTreeModel.insert((Object)folder2, (Object)folder, true);
    }

    public Folder delete(Folder folder) {
        return (Folder)this.folderTreeModel.delete((Object)folder);
    }

    public Folder getSelectedFolder() {
        return (Folder)this.folderTreeModel.valueByPath(this.folderTree.getSelectionPath());
    }

    public void setSelectedFolder(Folder folder) {
        if (folder != null) {
            this.folderTree.setSelectionPath(this.folderTreeModel.pathByValue((Object)folder));
        }
    }

    public void clearSelection() {
        if (!this.folderTree.getSelectionModel().isSelectionEmpty()) {
            this.folderTree.clearSelection();
        }
    }

    public void refresh() {
        this.folderTree.updateUI();
    }

    protected void update(List<Folder> list, boolean bl) {
        Folder folder = this.getSelectedFolder();
        this.folderTreeModel.clear();
        this.folderTreeModel.insert((TreeModelHierarchyIterator)new FolderTreeModelHierarchyIterator(list, bl));
        this.setSelectedFolder(folder);
    }

    JTree folderTree(CheckedValueTreeModel<Folder> checkedValueTreeModel, List<Folder> list, boolean bl, final FolderCellLabelBuilder folderCellLabelBuilder) {
        JTree jTree = new JTree();
        checkedValueTreeModel.insert((TreeModelHierarchyIterator)new FolderTreeModelHierarchyIterator(list, bl));
        jTree.setModel((TreeModel)checkedValueTreeModel);
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                CheckedValueTreeModel checkedValueTreeModel = (CheckedValueTreeModel)jTree.getModel();
                Folder folder = (Folder)checkedValueTreeModel.valueByPath(new TreePath(defaultMutableTreeNode.getPath()));
                if (folder != null) {
                    folderCellLabelBuilder.build(jLabel, folder);
                }
                return jLabel;
            }
        };
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        defaultTreeCellRenderer.setTextSelectionColor(defaultTreeCellRenderer.getBackgroundSelectionColor());
        defaultTreeCellRenderer.setBackgroundSelectionColor(jTree.getBackground());
        defaultTreeCellRenderer.setBorderSelectionColor(jTree.getBackground());
        jTree.setCellRenderer(defaultTreeCellRenderer);
        jTree.addMouseListener(new FolderTreeExtensionMouseListener());
        return jTree;
    }
}

