/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.foldertree;

import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import net.sf.amemailchecker.gui.component.tree.TreeModelHierarchyIterator;
import net.sf.amemailchecker.mail.model.Folder;

public class FolderTreeModelHierarchyIterator
implements TreeModelHierarchyIterator<Folder> {
    private final Stack<TreeModelHierarchyIterator> iterators = new Stack();
    private Folder next;
    private Folder parent;
    private boolean skip;
    private Collection<Folder> folders;

    public FolderTreeModelHierarchyIterator(Collection<Folder> collection) {
        this.folders = collection;
        this.reset();
    }

    public FolderTreeModelHierarchyIterator(Collection<Folder> collection, boolean bl) {
        this(collection);
        this.skip = bl;
    }

    public Folder next() {
        return this.next;
    }

    public boolean hasNext() {
        this.moveToNext();
        return this.next != null;
    }

    public boolean selected() {
        return this.next.isEnabled();
    }

    public Folder parent() {
        return this.parent;
    }

    public void reset() {
        this.iterators.clear();
        this.iterators.push(new AccountTreeModelHierarchyIteratorInt(null, this.folders));
    }

    private void moveToNext() {
        this.next = null;
        this.parent = null;
        if (!this.iterators.empty()) {
            if (!this.iterators.peek().hasNext()) {
                this.iterators.pop();
                this.moveToNext();
            } else {
                TreeModelHierarchyIterator treeModelHierarchyIterator = this.iterators.peek();
                Object object = treeModelHierarchyIterator.next();
                Object object2 = treeModelHierarchyIterator.parent();
                if (object instanceof TreeModelHierarchyIterator) {
                    this.iterators.push((TreeModelHierarchyIterator)object);
                    this.moveToNext();
                } else {
                    this.parent = (Folder)object2;
                    this.next = (Folder)object;
                    if (this.skip && !this.next.isEnabled()) {
                        this.moveToNext();
                    }
                }
            }
        }
    }

    private class AccountTreeModelHierarchyIteratorInt
    implements TreeModelHierarchyIterator<Folder> {
        private Folder parent;
        private Iterator<Folder> iterator;
        private Folder current;
        private Collection<Folder> folders;

        public AccountTreeModelHierarchyIteratorInt(Folder folder, Collection<Folder> collection) {
            this.folders = collection;
            this.parent = folder;
            this.iterator = collection.iterator();
        }

        public Folder next() {
            this.current = this.iterator.next();
            FolderTreeModelHierarchyIterator.this.iterators.push(new AccountTreeModelHierarchyIteratorInt(this.current, this.current.getChildren()));
            return this.current;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public boolean selected() {
            return this.current.isEnabled();
        }

        public Folder parent() {
            return this.parent;
        }

        public void reset() {
            this.iterator = this.folders.iterator();
            this.current = null;
        }
    }
}

