/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.foldertree;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTree;
import net.sf.amemailchecker.db.DefaultDAOFactory;
import net.sf.amemailchecker.db.common.DataBaseNegotiationException;
import net.sf.amemailchecker.gui.component.tree.CheckedValueTreeModel;
import net.sf.amemailchecker.gui.component.tree.DefaultCheckedValueTreeModel;
import net.sf.amemailchecker.gui.messageviewer.foldertree.FolderCellLabelBuilder;
import net.sf.amemailchecker.gui.messageviewer.foldertree.FolderTreeMediatorProxy;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;

public class LocalFolderTreeMediatorProxy
extends FolderTreeMediatorProxy {
    private static final Logger logger = Logger.getLogger(LocalFolderTreeMediatorProxy.class.getName());

    public void update(Account account) {
        this.update(this.folders(account), false);
    }

    @Override
    JTree folderTree(Account account) {
        FolderCellLabelBuilder folderCellLabelBuilder = new FolderCellLabelBuilder(){

            @Override
            public void build(JLabel jLabel, Folder folder) {
                int n = DefaultDAOFactory.getInstance().getLetterDAO().count(folder);
                if (n > 0) {
                    jLabel.setText(jLabel.getText() + " (" + n + ")");
                }
            }
        };
        this.folderTreeModel = new DefaultCheckedValueTreeModel();
        this.folderTree = this.folderTree((CheckedValueTreeModel<Folder>)this.folderTreeModel, this.folders(account), false, folderCellLabelBuilder);
        return this.folderTree;
    }

    private List<Folder> folders(Account account) {
        List<Folder> list;
        try {
            list = DefaultDAOFactory.getInstance().getFolderDAO().load(account.getUuid());
        }
        catch (DataBaseNegotiationException dataBaseNegotiationException) {
            logger.log(Level.INFO, "Unable to load list of local folders for account " + account);
            logger.log(Level.SEVERE, dataBaseNegotiationException.getMessage(), dataBaseNegotiationException);
            list = new ArrayList<Folder>();
        }
        return list;
    }
}

