/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.foldertree;

import javax.swing.JLabel;
import javax.swing.JTree;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.gui.component.tree.CheckedValueTreeModel;
import net.sf.amemailchecker.gui.component.tree.DefaultCheckedValueTreeModel;
import net.sf.amemailchecker.gui.component.tree.TreeModelFilter;
import net.sf.amemailchecker.gui.messageviewer.foldertree.FolderCellLabelBuilder;
import net.sf.amemailchecker.gui.messageviewer.foldertree.FolderTreeMediatorProxy;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;

public class RemoteFolderTreeMediatorProxy
extends FolderTreeMediatorProxy {
    public void update(Account account) {
        this.update(account.getMailBox().getFolders(), ApplicationContext.getInstance().getUserData().getMessageViewerPreferences().isRemoveDisabledFromFoldersView());
    }

    @Override
    JTree folderTree(final Account account) {
        FolderCellLabelBuilder folderCellLabelBuilder = new FolderCellLabelBuilder(){

            @Override
            public void build(JLabel jLabel, Folder folder) {
                int n = NotificationCache.getInstance().getPersistedCount(account, folder);
                if (n > 0) {
                    jLabel.setText(jLabel.getText() + " (" + n + ")");
                }
            }
        };
        this.folderTreeModel = new DefaultCheckedValueTreeModel();
        this.folderTreeModel.addFilter((TreeModelFilter)new TreeModelFilter<Folder>(){

            public boolean isVisible(Folder folder) {
                return folder.isSelectable();
            }
        });
        this.folderTree = this.folderTree((CheckedValueTreeModel<Folder>)this.folderTreeModel, account.getMailBox().getFolders(), ApplicationContext.getInstance().getUserData().getMessageViewerPreferences().isRemoveDisabledFromFoldersView(), folderCellLabelBuilder);
        return this.folderTree;
    }
}

