/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.messagedetails;

import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsActionExtensionPoint;
import net.sf.amemailchecker.app.extension.viewer.LetterDetailsMediator;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.app.model.UILetterDetailsModelChangeListener;
import net.sf.amemailchecker.gui.BaseFrame;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageDetailsEditState;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageDetailsPanel;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.MessageBodyPaneModel;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.model.MessageDetailsPanelModel;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Addressee;
import net.sf.amemailchecker.mail.model.Attachment;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.mail.model.PostalAddressee;

public class MessageDetailsMediator
implements LetterDetailsMediator {
    private MessageViewerContext context;
    private Letter message;
    private AccountBean account;
    private MessageDetailsPanel messageDetailsPanel;
    private MessageDetailsPanelModel messageDetailsPanelModel;

    public MessageDetailsMediator() {
    }

    public MessageDetailsMediator(Letter letter) {
        this.message = letter;
    }

    public MessageDetailsMediator(Letter letter, Account account) {
        this(letter);
        this.account = (AccountBean)account;
    }

    public MessageDetailsMediator(MessageViewerContext messageViewerContext) {
        this.context = messageViewerContext;
    }

    public void expandLetterDetails() {
        this.expandLetterDetails(this.message);
    }

    public void expandLetterDetails(Letter letter) {
        if (letter != null) {
            this.message = letter;
        }
        if (letter == null && this.message == null) {
            throw new IllegalArgumentException("Both message instances cannot be null");
        }
        MessageBodyPaneModel.DocumentsWrapper documentsWrapper = this.messageDetailsPanelModel.getMessageBodyModel().getMessageDocuments(letter);
        AccountBean accountBean = (AccountBean)this.context.getAccount();
        this.messageDetailsPanel.activateOnMessage(letter, this.context.getFolder());
        this.messageDetailsPanel.activateViewer((LetterImpl)letter);
        this.messageDetailsPanelModel.fireDataUpdate((LetterImpl)letter, accountBean);
        if (documentsWrapper != null) {
            this.messageDetailsPanelModel.getMessageBodyModel().putDocuments(documentsWrapper);
        }
        this.messageDetailsPanel.updateMessageBodyView(this.messageDetailsPanelModel);
    }

    public void flush(Letter ... letterArray) {
        this.messageDetailsPanelModel.getMessageBodyModel().removeDocuments(letterArray);
    }

    public Letter getMessage() {
        return this.message;
    }

    public void expandLetterToEdit(String string, String string2, MessageDetailsEditState messageDetailsEditState) {
        Addressee addressee = new Addressee(string, string2);
        ArrayList<PostalAddressee> arrayList = new ArrayList<PostalAddressee>();
        arrayList.add((PostalAddressee)addressee);
        this.message = new LetterImpl();
        ((LetterImpl)this.message).setRecipients("To", arrayList);
        this.expandLetterToEdit(messageDetailsEditState);
    }

    public void expandLetterToEdit(MessageDetailsEditState messageDetailsEditState) {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        BaseFrame baseFrame = new BaseFrame((ResourceContext)applicationContext);
        this.component((Window)baseFrame, LetterDetailsActionExtensionPoint.State.EDIT);
        this.messageDetailsPanel.switchPanels(true);
        this.messageDetailsPanelModel.fireDataUpdate((LetterImpl)this.message, this.account);
        this.messageDetailsPanel.editState(messageDetailsEditState);
        this.messageDetailsPanelModel.fillEdit(messageDetailsEditState);
        baseFrame.setTitle(applicationContext.getI18NBundleValue("dialog.message.editor.title"));
        baseFrame.getContentPane().add((Component)this.messageDetailsPanel, "Center");
        baseFrame.setVisible(true);
    }

    public synchronized MessageDetailsPanel component(Window window, LetterDetailsActionExtensionPoint.State state) {
        if (this.messageDetailsPanel != null) {
            return this.messageDetailsPanel;
        }
        this.messageDetailsPanelModel = new MessageDetailsPanelModel();
        this.messageDetailsPanel = new MessageDetailsPanel(this.messageDetailsPanelModel);
        this.messageDetailsPanel.registerExtensions(this.messageDetailsPanelModel, window, state);
        this.messageDetailsPanelModel.addChangeListener(new UILetterDetailsModelChangeListener(){

            public void stateChanged() {
                MessageDetailsMediator.this.messageDetailsPanel.onModelFireUpdate(MessageDetailsMediator.this.messageDetailsPanelModel);
            }

            public void attachmentInserted(Attachment attachment) {
                MessageDetailsMediator.this.messageDetailsPanel.addAttachment(attachment);
            }

            public void attachmentRemoved(Attachment attachment) {
                MessageDetailsMediator.this.messageDetailsPanel.removeAttachment(attachment);
            }
        });
        return this.messageDetailsPanel;
    }
}

