/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.messagedetails;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SpringLayout;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.app.extension.ExtensionProvider;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsActionContext;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsActionExtensionPoint;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsChangeListener;
import net.sf.amemailchecker.app.extension.letter.RecipientDocumentExtensionPoint;
import net.sf.amemailchecker.app.model.UILetterDetailsModel;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.impl.app.SaveAttachmentCommand;
import net.sf.amemailchecker.command.task.DefaultCommandExecutableTask;
import net.sf.amemailchecker.gui.ActionButtonPanel;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageDetailsEditState;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.DocumentCreationException;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.MessageBodyActionPanel;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.MessageBodyEditPanel;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.MessageBodyPane;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.UnsupportedMimeTypeException;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.model.DefaultRecipientDocument;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.model.MessageDetailsPanelModel;
import net.sf.amemailchecker.gui.util.SpringLayoutUtil;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Attachment;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.mail.model.PostalAddressee;

public class MessageDetailsPanel
extends JPanel {
    private ActionButtonPanel actionButtonPanel;
    private JLabel addressLabel;
    private JLabel ccLabel;
    private JLabel toLabel;
    private JTextPane from;
    private JTextPane to;
    private JTextPane cc;
    private JTextPane subject;
    private JTextField receivedDate;
    private JPanel headerPanel;
    private JPanel headerCaptionPanel;
    private MessageBodyPane bodyTextPane;
    private MessageBodyActionPanel messageBodyActionPanel;
    private MessageBodyEditPanel messageBodyEditPanel;
    private JPanel detailsPanel;
    private ResourceContext bundle = ApplicationContext.getInstance();
    private JPanel attachmentsPanel;

    public MessageDetailsPanel(MessageDetailsPanelModel messageDetailsPanelModel) {
        ActionControlFactory actionControlFactory = ActionControlFactory.Factory;
        this.headerPanel = new JPanel();
        this.headerPanel.setLayout(new SpringLayout());
        this.headerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.headerCaptionPanel = new JPanel();
        this.headerCaptionPanel.setLayout(new GridLayout(1, 2));
        this.addressLabel = new JLabel(this.bundle.getI18NBundleValue("message.field.from"), 0);
        this.from = actionControlFactory.getTextPane((StyledDocument)messageDetailsPanelModel.getFrom(), null);
        this.from.setEditable(false);
        this.from.addMouseListener(new PostalAddresseeExtensionMouseListener());
        this.addressLabel.setLabelFor(this.headerCaptionPanel);
        this.headerCaptionPanel.add(this.from);
        this.receivedDate = new JTextField();
        this.receivedDate.setDocument(messageDetailsPanelModel.getReceivedDate());
        this.receivedDate.setBackground(this.getBackground());
        this.receivedDate.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this.headerCaptionPanel.add(this.receivedDate);
        this.headerPanel.add(this.addressLabel);
        this.headerPanel.add(this.headerCaptionPanel);
        JLabel jLabel = new JLabel(this.bundle.getI18NBundleValue("message.field.subject"), 0);
        this.subject = actionControlFactory.getTextPane((StyledDocument)messageDetailsPanelModel.getSubject(), null);
        this.subject.setEditable(false);
        jLabel.setLabelFor(this.subject);
        this.headerPanel.add(jLabel);
        this.headerPanel.add(this.subject);
        this.toLabel = new JLabel(this.bundle.getI18NBundleValue("message.field.to"), 0);
        this.to = actionControlFactory.getTextPane((StyledDocument)messageDetailsPanelModel.getTo(), null);
        this.to.addMouseListener(new PostalAddresseeExtensionMouseListener());
        this.to.setEditable(false);
        this.toLabel.setLabelFor(this.to);
        this.headerPanel.add(this.toLabel);
        this.headerPanel.add(this.to);
        this.ccLabel = new JLabel(this.bundle.getI18NBundleValue("message.field.cc"), 0);
        this.cc = actionControlFactory.getTextPane((StyledDocument)messageDetailsPanelModel.getCc(), null);
        this.cc.setEditable(false);
        this.cc.addMouseListener(new PostalAddresseeExtensionMouseListener());
        this.ccLabel.setLabelFor(this.cc);
        this.headerPanel.add(this.ccLabel);
        this.headerPanel.add(this.cc);
        SpringLayoutUtil.makeCompactGrid((Container)this.headerPanel, (int)4, (int)2, (int)5, (int)5, (int)5, (int)5);
        this.bodyTextPane = new MessageBodyPane();
        this.bodyTextPane.setEditable(false);
        this.bodyTextPane.setModel(messageDetailsPanelModel.getMessageBodyModel());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)this.bodyTextPane, null);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.messageBodyActionPanel = new MessageBodyActionPanel(this.bodyTextPane);
        this.messageBodyActionPanel.setVisible(false);
        this.messageBodyEditPanel = new MessageBodyEditPanel(this.bodyTextPane);
        this.messageBodyEditPanel.setVisible(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.messageBodyEditPanel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.messageBodyActionPanel, "South");
        this.actionButtonPanel = new ActionButtonPanel();
        this.attachmentsPanel = new JPanel();
        this.attachmentsPanel.setLayout(new BoxLayout(this.attachmentsPanel, 3));
        this.attachmentsPanel.setBackground(this.bodyTextPane.getBackground());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.actionButtonPanel, "North");
        jPanel2.add((Component)this.headerPanel, "Center");
        jPanel2.add((Component)this.attachmentsPanel, "South");
        this.detailsPanel = new JPanel();
        this.detailsPanel.setLayout(new BorderLayout());
        this.detailsPanel.add((Component)jPanel2, "North");
        this.detailsPanel.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(Color.LIGHT_GRAY);
        this.setLayout(new CardLayout());
        this.add((Component)jPanel3, Boolean.FALSE.toString());
        this.add((Component)this.detailsPanel, Boolean.TRUE.toString());
        this.attachmentsPanel.setVisible(messageDetailsPanelModel.getAttachments().size() > 0);
    }

    public void switchPanels(boolean bl) {
        ((CardLayout)this.getLayout()).show(this, Boolean.toString(bl));
    }

    void onModelFireUpdate(MessageDetailsPanelModel messageDetailsPanelModel) {
        List<Attachment> list = messageDetailsPanelModel.getAttachments();
        this.attachmentsPanel.removeAll();
        for (Attachment attachment : list) {
            this.addAttachment(attachment);
        }
        this.attachmentsPanel.setVisible(list.size() > 0);
    }

    void activateViewer(LetterImpl letterImpl) {
        this.bodyTextPane.setEnabled(letterImpl.hasTexts());
        if (!letterImpl.hasTexts()) {
            this.bodyTextPane.setDocument(this.bodyTextPane.getEditorKit().createDefaultDocument());
        }
        this.bodyTextPane.setBackground(letterImpl.hasTexts() ? Color.WHITE : this.getBackground());
        this.messageBodyActionPanel.setVisible(letterImpl.getTexts().size() > 1);
    }

    public void editState(MessageDetailsEditState messageDetailsEditState) {
        this.to.setEditable(true);
        this.cc.setEditable(true);
        this.subject.setEditable(true);
        this.bodyTextPane.setEditable(true);
        try {
            if (!messageDetailsEditState.equals((Object)MessageDetailsEditState.COMPOSE_NEW)) {
                this.bodyTextPane.loadOnMessage("text/plain");
            }
            this.bodyTextPane.loadOnMessage("text/html");
        }
        catch (UnsupportedMimeTypeException unsupportedMimeTypeException) {
            unsupportedMimeTypeException.printStackTrace();
        }
        catch (DocumentCreationException documentCreationException) {
            documentCreationException.printStackTrace();
        }
        this.headerPanel.remove(this.addressLabel);
        this.headerPanel.remove(this.headerCaptionPanel);
        this.headerPanel.invalidate();
        this.headerPanel.repaint();
        this.headerPanel.revalidate();
        this.messageBodyEditPanel.setVisible(true);
        this.revalidate();
    }

    public void updateMessageBodyView(MessageDetailsPanelModel messageDetailsPanelModel) {
        this.attachmentsPanel.removeAll();
        this.attachmentsPanel.setVisible(false);
        for (Attachment attachment : messageDetailsPanelModel.getAttachments()) {
            this.addAttachment(attachment);
        }
        if (!this.bodyTextPane.isEnabled()) {
            return;
        }
        Object object = this.bodyTextPane.getModel().getSelectedContentType();
        if (object == null) {
            object = messageDetailsPanelModel.hasBody("text/plain") ? "text/plain" : "text/html";
        }
        this.messageBodyActionPanel.setViewSelection((String)object);
        try {
            this.bodyTextPane.loadOnMessage((String)object);
        }
        catch (UnsupportedMimeTypeException unsupportedMimeTypeException) {
            unsupportedMimeTypeException.printStackTrace();
        }
        catch (DocumentCreationException documentCreationException) {
            documentCreationException.printStackTrace();
        }
    }

    public void addAttachment(Attachment attachment) {
        JButton jButton = ActionControlFactory.Factory.createLinkButton();
        jButton.setText(attachment.getName());
        jButton.setToolTipText(attachment.getName());
        String string = this.bundle.getImageIcon("icon.attachment" + attachment.getType());
        if (string == null) {
            string = this.bundle.getImageIcon("icon.attachment");
        }
        jButton.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getClassLoader().getResource(string)).getScaledInstance(20, 15, 4)));
        jButton.setOpaque(false);
        jButton.putClientProperty(Attachment.class.getName(), attachment);
        jButton.addMouseListener(new AttachmentMouseListener());
        this.attachmentsPanel.add(jButton);
        this.attachmentsPanel.setVisible(true);
        this.revalidate();
    }

    public void removeAttachment(Attachment attachment) {
        for (Component component : this.attachmentsPanel.getComponents()) {
            Attachment attachment2 = (Attachment)((JComponent)component).getClientProperty(Attachment.class.getName());
            if (attachment2 == null || !attachment2.equals((Object)attachment)) continue;
            this.attachmentsPanel.remove(component);
            break;
        }
        this.attachmentsPanel.setVisible(this.attachmentsPanel.getComponents().length > 0);
        this.revalidate();
    }

    public void activateOnMessage(Letter letter, Folder folder) {
        List<LetterDetailsActionExtensionPoint> list = ExtensionProvider.Provider.getLetterDetailsActionExtensions();
        for (LetterDetailsActionExtensionPoint letterDetailsActionExtensionPoint : list) {
            LetterDetailsChangeListener letterDetailsChangeListener = letterDetailsActionExtensionPoint.letterChangeListener();
            if (letterDetailsChangeListener == null) continue;
            letterDetailsChangeListener.letterDetailsChanged(folder, letter, this.actionButtonPanel.getActionButtons(letterDetailsActionExtensionPoint.getClass().getName()));
        }
    }

    public void registerExtensions(UILetterDetailsModel uILetterDetailsModel, Window window, LetterDetailsActionExtensionPoint.State state) {
        this.actionButtonPanel.removeAll();
        List<LetterDetailsActionExtensionPoint> list = ExtensionProvider.Provider.getLetterDetailsActionExtensions();
        for (LetterDetailsActionExtensionPoint letterDetailsActionExtensionPoint : list) {
            if (!letterDetailsActionExtensionPoint.containsActions(state)) continue;
            LetterDetailsActionContext letterDetailsActionContext = new LetterDetailsActionContext();
            letterDetailsActionContext.setOwner(window);
            letterDetailsActionContext.setModel(uILetterDetailsModel);
            AbstractButton[] abstractButtonArray = letterDetailsActionExtensionPoint.action(letterDetailsActionContext, state);
            if (abstractButtonArray == null) continue;
            this.actionButtonPanel.addActionButtons(abstractButtonArray, letterDetailsActionExtensionPoint.getClass().getName());
        }
    }

    private final class PostalAddresseeExtensionMouseListener
    extends MouseAdapter {
        private PostalAddresseeExtensionMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getButton() != 1) {
                return;
            }
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getComponent();
            final DefaultRecipientDocument defaultRecipientDocument = (DefaultRecipientDocument)jTextComponent.getDocument();
            PostalAddressee postalAddressee = defaultRecipientDocument.getInput(n = jTextComponent.viewToModel(mouseEvent.getPoint()));
            if (postalAddressee == null) {
                return;
            }
            List<RecipientDocumentExtensionPoint> list = ExtensionProvider.Provider.getRecipientDocumentPoints();
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (RecipientDocumentExtensionPoint recipientDocumentExtensionPoint : list) {
                Action[] actionArray = recipientDocumentExtensionPoint.actions(postalAddressee);
                if (actionArray == null || actionArray.length <= 0) continue;
                for (Action action : actionArray) {
                    if (!action.isEnabled()) continue;
                    jPopupMenu.add(new JMenuItem(action));
                }
            }
            if (jPopupMenu.getComponentCount() <= 0) {
                return;
            }
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    defaultRecipientDocument.highlight(n);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    defaultRecipientDocument.normal();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    defaultRecipientDocument.normal();
                }
            });
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private final class AttachmentMouseListener
    extends MouseAdapter {
        private AttachmentMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 1 && mouseEvent.getButton() != 1) {
                return;
            }
            final Attachment attachment = (Attachment)((JComponent)mouseEvent.getSource()).getClientProperty(Attachment.class.getName());
            JMenu jMenu = new JMenu();
            jMenu.add(ActionControlFactory.Factory.getJMenuItem(MessageDetailsPanel.this.bundle.getI18NBundleValue("action.save"), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File file = new File(ApplicationContext.getInstance().getUserData().getPreferences().getDownloadsDirPath());
                    CommandExecutionService.Service.executeNotify(new DefaultCommandExecutableTask(new SaveAttachmentCommand(attachment, file)));
                }
            }));
            jMenu.add(ActionControlFactory.Factory.getJMenuItem(MessageDetailsPanel.this.bundle.getI18NBundleValue("action.save.as"), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setSelectedFile(new File(System.getProperty("user.home") + "/" + attachment.getName()));
                    jFileChooser.setMultiSelectionEnabled(false);
                    int n = jFileChooser.showSaveDialog(null);
                    if (n != 0) {
                        return;
                    }
                    CommandExecutionService.Service.executeNotify(new DefaultCommandExecutableTask(new SaveAttachmentCommand(attachment, jFileChooser.getSelectedFile())));
                }
            }));
            jMenu.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

