/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.messagedetails;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.amemailchecker.app.extension.letter.LetterDetailsActionExtensionPoint;
import net.sf.amemailchecker.app.extension.viewer.LettersTabMediator;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.gui.component.container.TabPane;
import net.sf.amemailchecker.gui.component.container.TabValueWrapper;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageDetailsMediator;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageDetailsPanel;
import net.sf.amemailchecker.mail.model.Letter;

public class MessageTabbedPane
extends TabPane<MessageDetailsMediator>
implements LettersTabMediator {
    public MessageTabbedPane() {
        this.addChangeListener(new TabChangeListener());
    }

    public void update(Letter letter) {
        TabValueWrapper<MessageDetailsMediator> tabValueWrapper = this.contains(letter);
        if (tabValueWrapper != null) {
            ((MessageDetailsMediator)tabValueWrapper.getValue()).expandLetterDetails(letter);
        }
    }

    public synchronized void insert(Letter letter) {
        TabValueWrapper tabValueWrapper = this.contains(letter);
        if (tabValueWrapper != null) {
            ((MessageDetailsMediator)tabValueWrapper.getValue()).expandLetterDetails(letter);
            this.setSelectedIndex(tabValueWrapper.getIndex());
            return;
        }
        MessageDetailsMediator messageDetailsMediator = new MessageDetailsMediator(MessageViewer.Viewer.getContext());
        MessageDetailsPanel messageDetailsPanel = messageDetailsMediator.component(MessageViewer.Viewer.getContext().getParentContainer(), LetterDetailsActionExtensionPoint.State.VIEW);
        messageDetailsPanel.switchPanels(true);
        this.addTab(letter.getSubject(), messageDetailsPanel, true);
        tabValueWrapper = new TabValueWrapper(this.getTabCount() - 1, (Object)messageDetailsMediator);
        this.wrappers.add(tabValueWrapper);
        messageDetailsMediator.expandLetterDetails(letter);
        this.setSelectedIndex(tabValueWrapper.getIndex());
    }

    public synchronized void remove(Letter ... letterArray) {
        for (Letter letter : letterArray) {
            TabValueWrapper<MessageDetailsMediator> tabValueWrapper = this.contains(letter);
            if (tabValueWrapper == null) continue;
            this.remove(tabValueWrapper.getIndex());
        }
    }

    TabValueWrapper<MessageDetailsMediator> contains(Letter letter) {
        for (TabValueWrapper tabValueWrapper : this.wrappers) {
            if (!((MessageDetailsMediator)tabValueWrapper.getValue()).getMessage().equals(letter)) continue;
            return tabValueWrapper;
        }
        return null;
    }

    public class TabChangeListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            MessageViewerContext messageViewerContext = MessageViewer.Viewer.getContext();
            int n = MessageTabbedPane.this.getSelectedIndex();
            if (n == 0 && messageViewerContext.getLettersTable().hasSelection()) {
                messageViewerContext.getLetterDetails().expandLetterDetails();
            } else {
                for (TabValueWrapper tabValueWrapper : MessageTabbedPane.this.wrappers) {
                    if (tabValueWrapper.getIndex() != n) continue;
                    ((MessageDetailsMediator)tabValueWrapper.getValue()).expandLetterDetails();
                }
            }
        }
    }
}

