/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.DocumentCreationException;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.MessageBodyPane;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.UnsupportedMimeTypeException;

public class MessageBodyActionPanel
extends JPanel {
    private MessageBodyPane messageBodyPane;
    private JPanel switchViewPanel;
    private ButtonGroup switchViewGroup;
    private JRadioButton textViewButton;
    private JRadioButton htmlViewButton;

    public MessageBodyActionPanel(MessageBodyPane messageBodyPane) {
        this.messageBodyPane = messageBodyPane;
        this.init();
    }

    public void init() {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        this.textViewButton = new JRadioButton();
        this.textViewButton.putClientProperty("contentType", "text/plain");
        this.textViewButton.setText(applicationContext.getI18NBundleValue("label.view.plain.text"));
        this.textViewButton.setOpaque(false);
        this.htmlViewButton = new JRadioButton();
        this.htmlViewButton.putClientProperty("contentType", "text/html");
        this.htmlViewButton.setText(applicationContext.getI18NBundleValue("label.view.html"));
        this.htmlViewButton.setOpaque(false);
        SwitchViewActionListener switchViewActionListener = new SwitchViewActionListener();
        this.textViewButton.addActionListener(switchViewActionListener);
        this.htmlViewButton.addActionListener(switchViewActionListener);
        this.switchViewGroup = new ButtonGroup();
        this.switchViewGroup.add(this.textViewButton);
        this.switchViewGroup.add(this.htmlViewButton);
        this.switchViewPanel = new JPanel();
        this.switchViewPanel.setLayout(new BoxLayout(this.switchViewPanel, 0));
        this.switchViewPanel.setOpaque(false);
        this.switchViewPanel.add(this.textViewButton);
        this.switchViewPanel.add(this.htmlViewButton);
        this.setBackground(this.messageBodyPane.getBackground());
        this.setLayout(new FlowLayout(0, 5, 0));
        this.add(this.switchViewPanel);
    }

    public void setViewSelection(String string) {
        this.switchViewGroup.setSelected(string.equals("text/plain") ? this.textViewButton.getModel() : this.htmlViewButton.getModel(), true);
    }

    public class SwitchViewActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            String string = (String)jComponent.getClientProperty("contentType");
            try {
                MessageBodyActionPanel.this.messageBodyPane.loadOnMessage(string);
                MessageBodyActionPanel.this.messageBodyPane.getModel().setSelectedContentType(string);
            }
            catch (UnsupportedMimeTypeException unsupportedMimeTypeException) {
                unsupportedMimeTypeException.printStackTrace();
            }
            catch (DocumentCreationException documentCreationException) {
                documentCreationException.printStackTrace();
            }
        }
    }
}

