/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview;

import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.model.PersonSignature;
import net.sf.amemailchecker.app.model.PersonalData;
import net.sf.amemailchecker.app.model.ValueIDComboModel;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.MessageBodyPane;

public class MessageBodyEditPanel
extends JPanel {
    private MessageBodyPane messageBodyPane;
    private JComboBox signaturesBox;

    public MessageBodyEditPanel(MessageBodyPane messageBodyPane) {
        this.messageBodyPane = messageBodyPane;
        this.init();
    }

    public void init() {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        PersonalData personalData = applicationContext.getUserData().getPersonalData();
        this.setBackground(this.messageBodyPane.getBackground());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.setLayout(new FlowLayout(0, 5, 0));
        this.signaturesBox = new JComboBox();
        ValueIDComboModel valueIDComboModel = new ValueIDComboModel();
        valueIDComboModel.addElement((Object)"", "--- " + applicationContext.getI18NBundleValue("label.signatures") + " ---");
        Map<String, PersonSignature> map = personalData.getSignatures();
        for (PersonSignature personSignature : map.values()) {
            valueIDComboModel.addElement((Object)personSignature.getUuid(), personSignature.getName());
        }
        PersonSignature personSignature = personalData.getDefaultSignature();
        valueIDComboModel.setSelectedItem((Object)(personSignature != null ? personSignature.getName() : ""));
        this.signaturesBox.setModel(valueIDComboModel);
        this.signaturesBox.addItemListener(new ChangeSignatureListener());
        this.add(this.signaturesBox);
    }

    public class ChangeSignatureListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                String string;
                ValueIDComboModel valueIDComboModel = (ValueIDComboModel)MessageBodyEditPanel.this.signaturesBox.getModel();
                String string2 = (String)valueIDComboModel.getSelected();
                String string3 = (String)valueIDComboModel.getLastSelected();
                if (string2.equals("") && string3.equals("")) {
                    return;
                }
                Map<String, PersonSignature> map = ApplicationContext.getInstance().getUserData().getPersonalData().getSignatures();
                String string4 = string = string2.equals("") ? "" : map.get(string2).getBody();
                if (string3.equals("")) {
                    MessageBodyEditPanel.this.messageBodyPane.getModel().insertInDocument(0, string);
                } else {
                    MessageBodyEditPanel.this.messageBodyPane.getModel().replaceInDocument(map.get(string3).getBody(), string);
                }
            }
        }
    }
}

