/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview;

import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.ImageView;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.MessageBodyPaneModel;
import net.sf.amemailchecker.mail.model.Attachment;

class MessageBodyImageView
extends ImageView {
    private MessageBodyPaneModel model;

    public MessageBodyImageView(Element element, MessageBodyPaneModel messageBodyPaneModel) {
        super(element);
        this.model = messageBodyPaneModel;
    }

    @Override
    public Image getImage() {
        String string = this.getImageName();
        Image image = this.model.getMessageDocuments().getImage(string);
        if (image != null) {
            return image;
        }
        for (Attachment attachment : this.model.getMessage().getInline()) {
            if (!attachment.getName().equals(string)) continue;
            image = Toolkit.getDefaultToolkit().createImage(attachment.getData());
            this.model.getMessageDocuments().addImage(string, image);
            return image;
        }
        if (this.isCompleteURL()) {
            image = super.getImage();
            if (image != null) {
                this.model.getMessageDocuments().addImage(string, image);
            }
            return image;
        }
        return null;
    }

    private boolean isCompleteURL() {
        Object object = this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
        if (object == null) {
            return false;
        }
        String string = ((String)object).toLowerCase();
        return string.startsWith("file") || string.startsWith("http");
    }

    private String getImageName() {
        Object object = this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
        if (object == null) {
            return "";
        }
        String[] stringArray = ((String)object).split("[/]");
        return stringArray[stringArray.length - 1];
    }
}

