/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview;

import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.DocumentCreationException;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.MessageBodyPaneModel;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.MessageBodyViewFactory;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.MimeTypeDocumentCreator;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.UnsupportedMimeTypeException;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;

public class MessageBodyPane
extends JEditorPane {
    private MessageBodyPaneModel model;

    public MessageBodyPane() {
    }

    public MessageBodyPane(MessageBodyPaneModel messageBodyPaneModel) {
        this.model = messageBodyPaneModel;
    }

    public void loadOnMessage(String string) throws UnsupportedMimeTypeException, DocumentCreationException {
        Document document = this.model.getDocument(string);
        EditorKit editorKit = this.getEditorKitForType(string);
        if (document == null) {
            if (string.equalsIgnoreCase("text/plain")) {
                document = new PlainTextDocumentCreator().create(editorKit);
            } else if (string.equalsIgnoreCase("text/html")) {
                document = new HtmlDocumentCreator().create(editorKit);
            } else {
                throw new UnsupportedMimeTypeException("Unsupported MIME type: " + string);
            }
            this.model.putDocument(document, string);
        }
        this.model.setSelectedContentType(string);
        this.setEditorKit(editorKit);
        this.setDocument(document);
    }

    public EditorKit getEditorKitForType(String string) throws UnsupportedMimeTypeException {
        if (string.equalsIgnoreCase("text/plain")) {
            return new StyledEditorKit();
        }
        if (string.equalsIgnoreCase("text/html")) {
            return new MessageBodyEditorKit();
        }
        throw new UnsupportedMimeTypeException("Unsupported MIME type: " + string);
    }

    public MessageBodyPaneModel getModel() {
        return this.model;
    }

    public void setModel(MessageBodyPaneModel messageBodyPaneModel) {
        this.model = messageBodyPaneModel;
    }

    private class HtmlDocumentCreator
    implements MimeTypeDocumentCreator {
        private HtmlDocumentCreator() {
        }

        @Override
        public Document create(EditorKit editorKit) throws DocumentCreationException {
            MessageBodyPane.this.setContentType("text/html");
            Document document = editorKit.createDefaultDocument();
            String string = MessageBodyPane.this.model.getMessage().getText("text/html");
            if (string != null) {
                try {
                    editorKit.read(new StringReader(string), document, 0);
                }
                catch (Exception exception) {
                    throw new DocumentCreationException(exception);
                }
            }
            return document;
        }
    }

    private class PlainTextDocumentCreator
    implements MimeTypeDocumentCreator {
        private PlainTextDocumentCreator() {
        }

        @Override
        public Document create(EditorKit editorKit) throws DocumentCreationException {
            MessageBodyPane.this.setContentType("text/plain");
            Document document = editorKit.createDefaultDocument();
            try {
                document.insertString(0, MessageBodyPane.this.model.getMessage().getText("text/plain"), null);
            }
            catch (BadLocationException badLocationException) {
                throw new DocumentCreationException(badLocationException);
            }
            return document;
        }
    }

    protected class MessageBodyEditorKit
    extends HTMLEditorKit {
        protected MessageBodyEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            LetterImpl letterImpl = MessageBodyPane.this.model.getMessage();
            return letterImpl != null ? new MessageBodyViewFactory(MessageBodyPane.this.model) : super.getViewFactory();
        }

        @Override
        public Document createDefaultDocument() {
            Document document = super.createDefaultDocument();
            document.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            return document;
        }
    }
}

