/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Letter;

public class MessageBodyPaneModel {
    private LetterImpl message;
    private Map<String, DocumentsWrapper> documents = new HashMap<String, DocumentsWrapper>();

    public void replaceInDocument(String string, String string2) {
        Document document = this.getSelectedDocument();
        try {
            String string3 = document.getText(0, document.getLength());
            int n = string3.indexOf(string);
            if (n != -1) {
                document.remove(n, string.length());
                document.insertString(n, string2, null);
            } else {
                document.insertString(document.getLength(), string2, null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void insertInDocument(int n, String string) {
        Document document = this.getSelectedDocument();
        n = n == -1 ? document.getLength() : n;
        try {
            document.insertString(n, string, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Document getSelectedDocument() {
        return this.getDocument(this.getMessageDocuments().getSelectedContentType());
    }

    public void setSelectedContentType(String string) {
        this.getMessageDocuments().setSelectedContentType(string);
    }

    public String getSelectedContentType() {
        return this.getMessageDocuments().getSelectedContentType();
    }

    public void putDocuments(DocumentsWrapper documentsWrapper) {
        this.documents.put(this.message.getUid(), documentsWrapper);
    }

    public void putDocument(Document document, String string) {
        DocumentsWrapper documentsWrapper = this.getMessageDocuments();
        documentsWrapper.putDocument(string, document);
    }

    public Document getDocument(String string) {
        return this.getMessageDocuments().getDocument(string);
    }

    public DocumentsWrapper getMessageDocuments(Letter letter) {
        DocumentsWrapper documentsWrapper = this.documents.get(letter.getUid());
        if (documentsWrapper == null) {
            documentsWrapper = new DocumentsWrapper();
            this.documents.put(letter.getUid(), documentsWrapper);
        }
        return documentsWrapper;
    }

    public DocumentsWrapper getMessageDocuments() {
        return this.getMessageDocuments(this.message);
    }

    public void clearDocuments() throws BadLocationException {
        Map<String, Document> map = this.getMessageDocuments().getDocuments();
        for (String string : map.keySet()) {
            Document document = map.get(string);
            if (document == null) continue;
            document.remove(0, document.getLength());
        }
    }

    public void removeDocuments(Letter ... letterArray) {
        for (Letter letter : letterArray) {
            this.documents.remove(letter.getUid());
        }
    }

    public void acceptUpdates() throws BadLocationException {
        Map<String, Document> map = this.getMessageDocuments().getDocuments();
        for (String string : map.keySet()) {
            Document document = map.get(string);
            if (document == null) continue;
            this.message.setText(string, document.getText(0, document.getLength()));
        }
    }

    public LetterImpl getMessage() {
        return this.message;
    }

    public void setMessage(LetterImpl letterImpl) {
        this.message = letterImpl;
    }

    public static class DocumentsWrapper {
        private Map<String, Document> documents = new HashMap<String, Document>();
        private String selectedContentType;
        private Map<String, Image> images = new HashMap<String, Image>();

        public Document getDocument(String string) {
            return this.documents.get(string);
        }

        public void putDocument(String string, Document document) {
            this.documents.put(string, document);
        }

        public Map<String, Document> getDocuments() {
            return this.documents;
        }

        public String getSelectedContentType() {
            return this.selectedContentType;
        }

        public void setSelectedContentType(String string) {
            this.selectedContentType = string;
        }

        public Map<String, Image> getImages() {
            return this.images;
        }

        public void addImage(String string, Image image) {
            this.images.put(string, image);
        }

        public Image getImage(String string) {
            return this.images.get(string);
        }
    }
}

