/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.messagedetails.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.sf.amemailchecker.app.model.RecipientDocument;
import net.sf.amemailchecker.mail.cache.PostalAddresseeCache;
import net.sf.amemailchecker.mail.model.Addressee;
import net.sf.amemailchecker.mail.model.PostalAddressee;
import net.sf.amemailchecker.util.StringUtil;

public class DefaultRecipientDocument
extends DefaultStyledDocument
implements RecipientDocument {
    private static SimpleAttributeSet highlightSet = new SimpleAttributeSet();
    private static SimpleAttributeSet plainSet;
    private static SimpleAttributeSet personalSet;
    private static SimpleAttributeSet onHoverSet;
    private Map<Position, PostalAddressee> values = new TreeMap<Position, PostalAddressee>();
    private Position currentHoveredPos;

    public void fill(List<PostalAddressee> list) throws BadLocationException {
        if (list == null) {
            return;
        }
        if (this.getLength() > 0) {
            this.insertString(this.getLength(), ", ", plainSet);
        }
        Iterator<PostalAddressee> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.fill(iterator.next());
            if (!iterator.hasNext()) continue;
            super.insertString(this.getLength(), " , ", plainSet);
        }
    }

    public void fill(PostalAddressee postalAddressee) throws BadLocationException {
        if (postalAddressee == null) {
            return;
        }
        boolean bl = PostalAddresseeCache.Instance.isPersonal(postalAddressee);
        boolean bl2 = PostalAddresseeCache.Instance.contains(postalAddressee);
        if (bl) {
            this.fill(postalAddressee, true, personalSet);
        } else {
            this.fill(postalAddressee, bl2, bl2 ? highlightSet : plainSet);
        }
    }

    private void fill(PostalAddressee postalAddressee, boolean bl, SimpleAttributeSet simpleAttributeSet) throws BadLocationException {
        Position position = new Position();
        position.setStart(this.getLength());
        position.setEditable(!bl);
        position.setAttributeSet(simpleAttributeSet);
        String string = postalAddressee.getLabel();
        String string2 = bl ? (StringUtil.isNullOrEmpty((String)string) ? postalAddressee.getAddress() : string) : postalAddressee.getAddress();
        super.insertString(this.getLength(), string2, simpleAttributeSet);
        position.setEnd(position.getStart() + string2.length());
        this.values.put(position, postalAddressee);
    }

    public void highlight(int n) {
        for (Position position : this.values.keySet()) {
            if (n < position.getStart() || position.getEnd() < n) continue;
            this.setCharacterAttributes(position.getStart(), position.getEnd() - position.getStart(), onHoverSet, true);
            this.currentHoveredPos = position;
            break;
        }
    }

    public void normal() {
        if (this.currentHoveredPos != null) {
            this.setCharacterAttributes(this.currentHoveredPos.getStart(), this.currentHoveredPos.getEnd() - this.currentHoveredPos.getStart(), this.currentHoveredPos.getAttributeSet(), true);
        }
        this.currentHoveredPos = null;
    }

    public List<PostalAddressee> getInput() {
        String[] stringArray;
        ArrayList<PostalAddressee> arrayList = new ArrayList<PostalAddressee>();
        arrayList.addAll(this.values.values());
        try {
            stringArray = this.getText(0, this.getLength()).split("[,]");
        }
        catch (BadLocationException badLocationException) {
            return arrayList;
        }
        for (String string : stringArray) {
            if ((string = string.trim()).equals("") || this.isAddressee(string)) continue;
            Addressee addressee = new Addressee();
            addressee.setAddress(string);
            PostalAddressee postalAddressee = PostalAddresseeCache.Instance.findByAddress(string);
            if (postalAddressee != null) {
                addressee.setLabel(postalAddressee.getDisplayName());
            }
            arrayList.add((PostalAddressee)addressee);
        }
        return arrayList;
    }

    public PostalAddressee getInput(int n) {
        for (Position position : this.values.keySet()) {
            if (n < position.getStart() || position.getEnd() < n) continue;
            return this.values.get(position);
        }
        return null;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        for (Position position : this.values.keySet()) {
            if (position.getStart() > n || position.getEnd() < n || position.isEditable()) continue;
            return;
        }
        super.insertString(n, string, plainSet);
    }

    public void clear() {
        this.values.clear();
        try {
            super.remove(0, this.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        int n3 = 0;
        Iterator<Position> iterator = this.values.keySet().iterator();
        while (iterator.hasNext()) {
            Position position = iterator.next();
            if (position.getStart() > n || position.getEnd() < n || position.isEditable()) continue;
            int n4 = position.getEnd() - position.getStart();
            super.remove(position.getStart(), n4 + 1);
            n3 += n4;
            iterator.remove();
            this.narrowPositions(n, n4);
        }
        if (n3 < n2) {
            super.remove(n, n2 - n3);
        }
    }

    @Override
    public String getText(int n, int n2) throws BadLocationException {
        String string = super.getText(n, n2);
        string = string.trim();
        return StringUtil.trimWith((String)string, (String)"", (String)",").trim();
    }

    private void narrowPositions(int n, int n2) {
        for (Position position : this.values.keySet()) {
            if (position.getStart() <= n) continue;
            position.setStart(position.getStart() - n2);
            position.setEnd(position.getEnd() - n2);
        }
    }

    private boolean isAddressee(String string) {
        boolean bl = false;
        for (PostalAddressee postalAddressee : this.values.values()) {
            if (!postalAddressee.getLabel().equals(string) && !postalAddressee.getAddress().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    static {
        highlightSet.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
        highlightSet.addAttribute(StyleConstants.Foreground, Color.GRAY);
        plainSet = new SimpleAttributeSet();
        plainSet.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.FALSE);
        plainSet.addAttribute(StyleConstants.Foreground, Color.BLACK);
        personalSet = new SimpleAttributeSet();
        personalSet.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
        personalSet.addAttribute(StyleConstants.Foreground, Color.BLUE);
        onHoverSet = new SimpleAttributeSet();
        onHoverSet.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
        onHoverSet.addAttribute(StyleConstants.Foreground, new Color(188, 210, 230));
    }

    private class Position
    implements Comparable<Position> {
        private int start;
        private int end;
        private boolean editable;
        private SimpleAttributeSet attributeSet;

        private Position() {
        }

        public boolean isEditable() {
            return this.editable;
        }

        public void setEditable(boolean bl) {
            this.editable = bl;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int n) {
            this.start = n;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int n) {
            this.end = n;
        }

        public SimpleAttributeSet getAttributeSet() {
            return this.attributeSet;
        }

        public void setAttributeSet(SimpleAttributeSet simpleAttributeSet) {
            this.attributeSet = simpleAttributeSet;
        }

        @Override
        public int compareTo(Position position) {
            if (position.getStart() > this.start) {
                return -1;
            }
            if (position.getStart() < this.start) {
                return 1;
            }
            return 0;
        }
    }
}

