/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.messagedetails.model;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.MinimalHTMLWriter;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.app.model.PersonSignature;
import net.sf.amemailchecker.app.model.RecipientDocument;
import net.sf.amemailchecker.app.model.UILetterDetailsModel;
import net.sf.amemailchecker.app.model.UILetterDetailsModelChangeListener;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageDetailsEditState;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.messagebodyview.MessageBodyPaneModel;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.model.DefaultRecipientDocument;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.model.ModelProcessorFactory;
import net.sf.amemailchecker.mail.impl.letter.LetterImpl;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Attachment;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.util.DateUtil;

public class MessageDetailsPanelModel
implements UILetterDetailsModel {
    private LetterImpl letter;
    AccountBean account;
    private StyledDocument subject;
    private Document receivedDate;
    private RecipientDocument from;
    private RecipientDocument to;
    private RecipientDocument cc;
    private MessageBodyPaneModel messageBodyModel;
    private List<Attachment> attachments;
    private EventListenerList listenerList = new EventListenerList();

    public MessageDetailsPanelModel() {
        this.subject = new DefaultStyledDocument();
        this.receivedDate = new PlainDocument();
        this.from = new DefaultRecipientDocument();
        this.to = new DefaultRecipientDocument();
        this.cc = new DefaultRecipientDocument();
        this.messageBodyModel = new MessageBodyPaneModel();
        this.attachments = new ArrayList<Attachment>();
    }

    public void fireDataUpdate(LetterImpl letterImpl, AccountBean accountBean) {
        this.letter = letterImpl;
        this.account = accountBean;
        this.clear();
        this.fill();
        this.stateChanged();
    }

    public void fill() {
        try {
            this.subject.insertString(0, this.letter.getSubject(), null);
            this.receivedDate.insertString(0, DateUtil.formatDate((Date)this.letter.getDate()), null);
            this.from.fill(this.letter.getSender());
            this.to.fill(this.letter.getRecipients("To"));
            this.cc.fill(this.letter.getRecipients("CC"));
            this.messageBodyModel.setMessage(this.letter);
            this.attachments.addAll(this.letter.getAttachments());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void clear() {
        this.from.clear();
        this.to.clear();
        this.cc.clear();
        try {
            this.subject.remove(0, this.subject.getLength());
            this.receivedDate.remove(0, this.receivedDate.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.attachments.clear();
    }

    public void fillEdit(MessageDetailsEditState messageDetailsEditState) {
        try {
            this.subject.insertString(0, messageDetailsEditState.equals((Object)MessageDetailsEditState.FORWARD) ? "FWD: " : "RE: ", null);
            ModelProcessorFactory.loadProcessor(messageDetailsEditState, this).process(this.letter);
            this.from.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void insertSignature() throws BadLocationException {
        PersonSignature personSignature = ApplicationContext.getInstance().getUserData().getPersonalData().getDefaultSignature();
        if (personSignature != null) {
            this.messageBodyModel.insertInDocument(0, personSignature.getBody() + "\n");
        }
    }

    public void insertAttachment(Attachment attachment) {
        if (!this.attachments.contains(attachment)) {
            this.attachments.add(attachment);
            for (UILetterDetailsModelChangeListener uILetterDetailsModelChangeListener : this.getListeners()) {
                uILetterDetailsModelChangeListener.attachmentInserted(attachment);
            }
        }
    }

    public void removeAttachment(Attachment attachment) {
        if (this.attachments.contains(attachment)) {
            Iterator<Attachment> iterator = this.attachments.iterator();
            while (iterator.hasNext()) {
                Attachment attachment2 = iterator.next();
                if (!attachment2.equals((Object)attachment)) continue;
                iterator.remove();
                for (UILetterDetailsModelChangeListener uILetterDetailsModelChangeListener : this.getListeners()) {
                    uILetterDetailsModelChangeListener.attachmentRemoved(attachment);
                }
            }
        }
    }

    public LetterImpl acceptChanges() {
        try {
            Map<String, Document> map = this.messageBodyModel.getMessageDocuments().getDocuments();
            HTMLDocument hTMLDocument = (HTMLDocument)map.get("text/html");
            StringWriter stringWriter = new StringWriter(hTMLDocument.getLength());
            new MinimalHTMLWriter((Writer)stringWriter, hTMLDocument).write();
            stringWriter.flush();
            String string = stringWriter.getBuffer().toString();
            this.letter.setText("text/html", string);
            this.letter.setText("text/plain", hTMLDocument.getText(0, hTMLDocument.getLength()));
            this.letter.setSubject(this.subject.getText(0, this.subject.getLength()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.letter.setRecipients("To", this.to.getInput());
        this.letter.setRecipients("CC", this.cc.getInput());
        for (Attachment attachment : this.attachments) {
            if (this.letter.getAttachments().contains(attachment)) continue;
            this.letter.getAttachments().add(attachment);
        }
        return this.letter;
    }

    public Letter declineChanges() {
        return this.letter;
    }

    public void fireModelUpdate(Letter letter) {
    }

    public Letter getLetter() {
        return this.letter;
    }

    public Account getAccount() {
        return this.account;
    }

    public boolean hasBody(String string) {
        String string2 = this.letter.getText(string);
        return string2 != null && !string2.equals("");
    }

    public Document getSubject() {
        return this.subject;
    }

    public Document getReceivedDate() {
        return this.receivedDate;
    }

    public RecipientDocument getFrom() {
        return this.from;
    }

    public RecipientDocument getCc() {
        return this.cc;
    }

    public RecipientDocument getTo() {
        return this.to;
    }

    public MessageBodyPaneModel getMessageBodyModel() {
        return this.messageBodyModel;
    }

    public List<Attachment> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    public Document getBody(String string) {
        return this.messageBodyModel.getDocument(string);
    }

    public void addChangeListener(UILetterDetailsModelChangeListener uILetterDetailsModelChangeListener) {
        this.listenerList.add(UILetterDetailsModelChangeListener.class, uILetterDetailsModelChangeListener);
    }

    public UILetterDetailsModelChangeListener[] getListeners() {
        return (UILetterDetailsModelChangeListener[])this.listenerList.getListeners(UILetterDetailsModelChangeListener.class);
    }

    private synchronized void stateChanged() {
        for (UILetterDetailsModelChangeListener uILetterDetailsModelChangeListener : this.getListeners()) {
            uILetterDetailsModelChangeListener.stateChanged();
        }
    }
}

