/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.messagetable;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.ExtensionProvider;
import net.sf.amemailchecker.app.extension.viewer.LettersTableMediator;
import net.sf.amemailchecker.app.extension.viewer.ViewerExtensionPoint;
import net.sf.amemailchecker.gui.component.ArrowIcon;
import net.sf.amemailchecker.gui.component.table.CheckedValueTableModel;
import net.sf.amemailchecker.gui.component.table.CheckedValueTableWrapper;
import net.sf.amemailchecker.gui.component.table.RowComparator;
import net.sf.amemailchecker.gui.component.table.SelectionHeaderCellRenderer;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.gui.messageviewer.messagetable.MessageTableMouseListener;
import net.sf.amemailchecker.mail.model.Letter;
import net.sf.amemailchecker.util.DateUtil;

public class DefaultLettersTableMediator
implements LettersTableMediator {
    private JTable component;
    private CheckedValueTableModel<Letter> model;

    public Letter[] getSelected(boolean bl) {
        List list = this.model.getMultipleSelection(this.component.getSelectedRows(), bl);
        return list.toArray(new Letter[list.size()]);
    }

    public Letter[] getChecked(boolean bl) {
        List list = this.model.getChecked(bl);
        return list.toArray(new Letter[list.size()]);
    }

    public Letter getSingle(boolean bl) {
        int n = this.component.getSelectedRow();
        if (n == -1) {
            return null;
        }
        Letter letter = (Letter)this.model.getSingleSelected(n);
        if (bl) {
            this.model.removeRowValue(this.component.getSelectedRow());
        }
        return letter;
    }

    public Letter[] get(boolean bl) {
        List list = this.model.values();
        if (bl) {
            this.clear();
        }
        return list.toArray(new Letter[list.size()]);
    }

    public synchronized void insert(boolean bl, Letter ... letterArray) {
        if (bl) {
            this.model.clearSelection();
            this.model.clear();
        }
        Letter letter = this.getSingle(false);
        this.model.insert((Object[])letterArray);
        this.setSingleSelected(letter);
        this.sort(3, this.model.getSortOrder(3));
    }

    public void remove(Letter letter) {
        this.model.remove((Object)letter);
    }

    public synchronized void clear() {
        if (this.empty()) {
            return;
        }
        this.model.clearSelection();
        this.model.clear();
    }

    public void sort(int n, boolean bl) {
        Letter letter = this.getSingle(false);
        this.model.sort(n, bl);
        this.setSingleSelected(letter);
    }

    public void setSingleSelected(Letter letter) {
        int n = this.model.getSingleSelectedIndex((Object)letter);
        if (n != -1) {
            this.changeSelection(n);
        }
    }

    public boolean hasSelection() {
        return this.component.getSelectedRows().length > 0;
    }

    public int count() {
        return this.component.getModel().getRowCount();
    }

    public boolean empty() {
        return this.count() <= 0;
    }

    public void changeSelection(int n) {
        this.component.changeSelection(n, 0, false, false);
    }

    public synchronized JTable component() {
        if (this.component != null) {
            return this.component;
        }
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        this.component = new JTable();
        this.model = new CheckedValueTableModel<Letter>(){

            protected void propagateToRow(Object[] objectArray, Letter letter) {
                objectArray[1] = letter.getSender().toString();
                objectArray[2] = letter.getSubject();
            }

            protected Object getValueAt(Letter letter, int n) {
                switch (n) {
                    case 1: {
                        return letter.getSender().toString();
                    }
                    case 2: {
                        return letter.getSubject();
                    }
                    case 3: {
                        return DateUtil.formatDate((Date)letter.getDate());
                    }
                }
                return null;
            }
        };
        this.model.assignComparator(3, (RowComparator)new RowComparator<Letter>(){

            public int compare(CheckedValueTableWrapper<Letter> checkedValueTableWrapper, CheckedValueTableWrapper<Letter> checkedValueTableWrapper2) {
                long l;
                Date date = ((Letter)checkedValueTableWrapper.getValue()).getDate();
                Date date2 = ((Letter)checkedValueTableWrapper2.getValue()).getDate();
                if (date == null && date2 == null) {
                    return 0;
                }
                if (date == null) {
                    return -1;
                }
                if (date2 == null) {
                    return 1;
                }
                long l2 = ((Letter)checkedValueTableWrapper.getValue()).getDate().getTime();
                if (l2 < (l = ((Letter)checkedValueTableWrapper2.getValue()).getDate().getTime())) {
                    return this.ordering ? 1 : -1;
                }
                if (l2 > l) {
                    return this.ordering ? -1 : 1;
                }
                return 0;
            }
        });
        this.model.addColumn((Object)"");
        this.model.addColumn((Object)applicationContext.getI18NBundleValue("label.sender"));
        this.model.addColumn((Object)applicationContext.getI18NBundleValue("message.field.subject"));
        this.model.addColumn((Object)applicationContext.getI18NBundleValue("message.field.date"));
        this.component.setModel((TableModel)this.model);
        this.component.setRowHeight((int)((double)this.component.getRowHeight() * 1.5));
        TableColumn tableColumn = this.component.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(50);
        tableColumn.setHeaderRenderer((TableCellRenderer)new SelectionHeaderCellRenderer());
        tableColumn = this.component.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(300);
        tableColumn.setMaxWidth(400);
        tableColumn = this.component.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(150);
        tableColumn.setMaxWidth(200);
        tableColumn.setHeaderRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                defaultTableCellRenderer.setIcon((Icon)new ArrowIcon(DefaultLettersTableMediator.this.model.getSortOrder(n2), jTable.getRowHeight() / 2));
                defaultTableCellRenderer.setHorizontalAlignment(0);
                defaultTableCellRenderer.setAlignmentX(0.5f);
                defaultTableCellRenderer.setOpaque(false);
                defaultTableCellRenderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return defaultTableCellRenderer;
            }
        });
        this.component.addMouseListener(new MessageTableMouseListener(this));
        this.component.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = DefaultLettersTableMediator.this.component.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                if (n == 3) {
                    DefaultLettersTableMediator.this.sort(n, !DefaultLettersTableMediator.this.model.getSortOrder(3));
                }
            }
        });
        for (ViewerExtensionPoint viewerExtensionPoint : ExtensionProvider.Provider.getViewerExtensionPoints()) {
            Map map = viewerExtensionPoint.onLetter(MessageViewer.Viewer.getContext());
            if (map == null) continue;
            for (KeyStroke keyStroke : map.keySet()) {
                Action action = (Action)map.get(keyStroke);
                this.component.getInputMap().put(keyStroke, action.getClass().getName());
                this.component.getActionMap().put(action.getClass().getName(), action);
            }
        }
        return this.component;
    }
}

