/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.messagetable;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import net.sf.amemailchecker.app.extension.DefaultMailActionContext;
import net.sf.amemailchecker.app.extension.ExtensionProvider;
import net.sf.amemailchecker.app.extension.MailActionContext;
import net.sf.amemailchecker.app.extension.viewer.MessageViewerContext;
import net.sf.amemailchecker.app.extension.viewer.ViewerExtensionPoint;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.gui.messageviewer.messagetable.DefaultLettersTableMediator;

public class MessageTableMouseListener
extends MouseAdapter {
    private DefaultLettersTableMediator mediator;

    public MessageTableMouseListener(DefaultLettersTableMediator defaultLettersTableMediator) {
        this.mediator = defaultLettersTableMediator;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getComponent();
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
            MessageViewer.Viewer.getContext().getLettersTabbedPane().insert(this.mediator.getSingle(false));
        }
        if (mouseEvent.getButton() == 3 && !jTable.getSelectionModel().isSelectionEmpty()) {
            List<ViewerExtensionPoint> list = ExtensionProvider.Provider.getViewerExtensionPoints();
            MessageViewerContext messageViewerContext = MessageViewer.Viewer.getContext();
            DefaultMailActionContext defaultMailActionContext = new DefaultMailActionContext();
            defaultMailActionContext.setAccount(messageViewerContext.getAccount());
            defaultMailActionContext.setFolder(messageViewerContext.getFolder());
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (ViewerExtensionPoint viewerExtensionPoint : list) {
                Action[] actionArray = viewerExtensionPoint.onLetter(messageViewerContext, (MailActionContext)defaultMailActionContext);
                if (actionArray == null || actionArray.length <= 0) continue;
                for (Action action : actionArray) {
                    if (!action.isEnabled()) continue;
                    jPopupMenu.add(new JMenuItem(action));
                }
            }
            if (jPopupMenu.getComponentCount() <= 0) {
                return;
            }
            jPopupMenu.show(jTable, mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

