/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.statusbar;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;

class ProgressBarComposite
extends JPanel {
    private JProgressBar progressBar;
    private int progressBarIncrement = 0;
    private ResourceContext bundle;

    public ProgressBarComposite() {
        this.init();
    }

    private void init() {
        this.bundle = ApplicationContext.getInstance();
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.progressBar);
    }

    public synchronized void startProgress() {
        this.progressBar.setIndeterminate(true);
        ++this.progressBarIncrement;
        this.updateTasksLabel();
    }

    public synchronized void stopProgress() {
        if (this.progressBarIncrement > 0) {
            --this.progressBarIncrement;
        }
        if (this.progressBarIncrement == 0) {
            this.progressBar.setIndeterminate(false);
        }
        this.updateTasksLabel();
    }

    public synchronized void updateProgress(int n) {
        this.progressBar.setIndeterminate(true);
        this.progressBarIncrement += n;
        this.updateTasksLabel();
    }

    private void updateTasksLabel() {
        this.progressBar.setString(Integer.toString(this.progressBarIncrement));
        this.progressBar.setToolTipText(Integer.toString(this.progressBarIncrement) + " " + this.bundle.getI18NBundleValue("tooltip.num.tasks.run"));
    }
}

