/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.messageviewer.statusbar;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.command.CommandExecutionEvent;
import net.sf.amemailchecker.command.exception.CommandExecutionException;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.messageviewer.statusbar.ProgressBarComposite;
import net.sf.amemailchecker.gui.notification.window.modal.MultipleNotificationWindow;
import net.sf.amemailchecker.util.GenericObserver;

public class StatusBar
extends JPanel {
    private JLabel infoTextLabel;
    private JButton notificationButton;
    private ProgressBarComposite progressBar;
    private JPanel contentPanel;
    private ResourceContext bundle;
    private MultipleNotificationWindow notificationsWindow;
    private JFrame parent;
    private ProgressBarEventObserver progressBarEventObserver;

    public StatusBar(JFrame jFrame) {
        this.parent = jFrame;
        this.progressBarEventObserver = new ProgressBarEventObserver();
        this.init();
    }

    private void init() {
        this.bundle = ApplicationContext.getInstance();
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 25));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ActionControlFactory actionControlFactory = ActionControlFactory.Factory;
        this.notificationsWindow = new MultipleNotificationWindow((Window)this.parent);
        this.notificationsWindow.setEmptyMessage(this.bundle.getI18NBundleValue("message.no.active.notifications"));
        this.notificationsWindow.setActionButtonText(ApplicationContext.getInstance().getI18NBundleValue("action.close.label"));
        this.notificationsWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatusBar.this.notificationButton.setIcon(StatusBar.this.bundle.loadImageIcon("icon.info"));
            }
        });
        this.infoTextLabel = new JLabel();
        this.infoTextLabel.setFont(new Font("SansSerif", 1, 8));
        this.infoTextLabel.setHorizontalAlignment(2);
        this.infoTextLabel.setHorizontalTextPosition(2);
        this.infoTextLabel.setMinimumSize(new Dimension(200, 25));
        this.notificationButton = actionControlFactory.createSimpleActionButton(this.bundle.loadImageIcon("icon.info"));
        this.notificationButton.setContentAreaFilled(false);
        this.notificationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatusBar.this.notificationsWindow.setVisible(true);
                StatusBar.this.updateNotificationsToolTip();
            }
        });
        this.updateNotificationsToolTip();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new FlowLayout(0));
        this.progressBar = new ProgressBarComposite();
        this.progressBar.setMinimumSize(new Dimension(100, 15));
        this.progressBar.stopProgress();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.infoTextLabel, gridBagConstraints);
        this.insertSeparator(new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.contentPanel, gridBagConstraints);
        this.insertSeparator(new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.notificationButton, gridBagConstraints);
        this.insertSeparator(new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add((Component)this.progressBar, gridBagConstraints);
    }

    private void insertSeparator(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 5, 7, 5);
        this.add((Component)new JSeparator(1), gridBagConstraints);
    }

    public void setInfoText(String string) {
        this.infoTextLabel.setText(string);
    }

    private void updateNotificationsToolTip() {
        this.notificationButton.setToolTipText(this.notificationsWindow.getNotificationsSize() + " " + this.bundle.getI18NBundleValue("tooltip.num.notif.error"));
    }

    public void addNotification(String string, String string2) {
        this.notificationsWindow.addNotification(string, string2);
        this.notificationButton.setIcon(this.bundle.loadImageIcon("icon.info.error"));
        this.updateNotificationsToolTip();
    }

    public ProgressBarEventObserver getProgressBarEventObserver() {
        return this.progressBarEventObserver;
    }

    private class ProgressBarEventObserver
    implements GenericObserver<CommandExecutionEvent> {
        private ProgressBarEventObserver() {
        }

        public void updatePerformed(CommandExecutionEvent commandExecutionEvent) {
            switch (commandExecutionEvent.getType()) {
                case COMPLETED: {
                    StatusBar.this.progressBar.stopProgress();
                    break;
                }
                case FAILED: {
                    StatusBar.this.progressBar.stopProgress();
                    CommandExecutionException commandExecutionException = commandExecutionEvent.getExecutable().getException();
                    StatusBar.this.addNotification(ApplicationContext.getInstance().getExceptionCodesBundle().get(commandExecutionException.getExceptionCode().getIdString()), commandExecutionException.getMessage());
                    break;
                }
                case STARTED: {
                    StatusBar.this.progressBar.startProgress();
                }
            }
        }
    }
}

