/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.mail;

import java.awt.Color;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.app.notification.SimpleMailNotification;
import net.sf.amemailchecker.gui.ActionControlFactory;

class AccountNotificationPanel
extends JPanel {
    private JLabel info;
    private JLabel count;
    private JButton accountBtn;
    private ResourceContext bundle = ApplicationContext.getInstance();

    AccountNotificationPanel(SimpleMailNotification simpleMailNotification) {
        this.init(simpleMailNotification);
    }

    private void init(SimpleMailNotification simpleMailNotification) {
        this.setLayout(new FlowLayout(0));
        this.setOpaque(false);
        this.accountBtn = ActionControlFactory.Factory.createLinkButton();
        this.accountBtn.setText(simpleMailNotification.getAccount().getTitle());
        this.accountBtn.setHorizontalAlignment(2);
        this.accountBtn.putClientProperty("account", simpleMailNotification.getAccount());
        this.info = new JLabel();
        this.info.setHorizontalAlignment(0);
        this.info.setForeground(Color.RED);
        this.count = new JLabel();
        this.count.setHorizontalAlignment(4);
        if (simpleMailNotification.getError() != null) {
            this.updateInfo(this.bundle.getI18NBundleValue("tooltip.error"));
            this.accountBtn.setEnabled(false);
            this.add(this.accountBtn);
            this.add(this.info);
        } else {
            this.add(this.accountBtn);
            this.add(this.info);
            this.add(this.count);
        }
    }

    JButton getAccountBtn() {
        return this.accountBtn;
    }

    void updateInfo(String string) {
        this.info.setText(string);
    }

    void updateInfo(int n) {
        this.info.setText(n > 0 ? n + " " + this.bundle.getI18NBundleValue("label.received") : this.bundle.getI18NBundleValue("label.no.new.messages"));
    }

    void updateCount(int n) {
        this.count.setText("(" + n + " " + this.bundle.getI18NBundleValue("label.total.unread") + ")");
    }
}

