/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.mail;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.app.extension.DefaultNotificationActionContext;
import net.sf.amemailchecker.app.extension.ExtensionProvider;
import net.sf.amemailchecker.app.extension.notification.NotificationAction;
import net.sf.amemailchecker.app.extension.notification.NotificationActionContext;
import net.sf.amemailchecker.app.extension.notification.NotificationExtensionPoint;
import net.sf.amemailchecker.app.extension.notification.NotificationExtensionType;
import net.sf.amemailchecker.app.notification.MailNotification;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.app.notification.SimpleMailNotification;
import net.sf.amemailchecker.gui.notification.mail.AccountNotificationPanel;
import net.sf.amemailchecker.gui.notification.panel.TextMultiLinePanel;
import net.sf.amemailchecker.gui.notification.window.desktop.slidein.BaseSlideNotificationWindow;
import net.sf.amemailchecker.mail.model.Account;

abstract class BaseMailNotificationWindow<T extends MailNotification>
extends BaseSlideNotificationWindow {
    protected static final String PROPERTY_ACCOUNT = "account";
    ResourceContext bundle;
    List<T> notificationData;
    Map<String, JPanel> notificationPanels;

    BaseMailNotificationWindow(List<T> list, ResourceContext resourceContext) {
        this.notificationData = list;
        this.bundle = resourceContext;
        this.notificationPanels = new HashMap<String, JPanel>();
        this.init();
    }

    protected JPanel constructAccountNotificationPanel(SimpleMailNotification simpleMailNotification) {
        AccountNotificationPanel accountNotificationPanel = new AccountNotificationPanel(simpleMailNotification);
        if (simpleMailNotification.getError() != null) {
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(accountNotificationPanel);
            jPanel.add((Component)new TextMultiLinePanel(simpleMailNotification.getError(), false));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            return jPanel;
        }
        accountNotificationPanel.getAccountBtn().addActionListener(new OnAccountActionListener());
        if (simpleMailNotification.getAccount().isActive()) {
            accountNotificationPanel.updateInfo(simpleMailNotification.getUnreadNewCount());
        } else {
            accountNotificationPanel.updateInfo(this.bundle.getI18NBundleValue("label.inactive"));
        }
        accountNotificationPanel.updateCount(simpleMailNotification.getUnreadCount());
        return accountNotificationPanel;
    }

    abstract void updateOnAccount(Account var1);

    synchronized void displayExtensionMenu(DefaultNotificationActionContext defaultNotificationActionContext, JComponent jComponent) {
        defaultNotificationActionContext.setInvoker((JWindow)((Object)this));
        JPopupMenu jPopupMenu = new JPopupMenu();
        List<NotificationExtensionPoint> list = ExtensionProvider.Provider.getNotificationExtensions();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            NotificationExtensionPoint notificationExtensionPoint = list.get(i);
            NotificationAction[] notificationActionArray = notificationExtensionPoint.actions(defaultNotificationActionContext.getType());
            if (notificationActionArray == null || notificationActionArray.length <= 0) continue;
            if (n > 0) {
                jPopupMenu.add(new JSeparator(0));
            }
            boolean bl = false;
            for (NotificationAction notificationAction : notificationActionArray) {
                notificationAction.setContext((NotificationActionContext)defaultNotificationActionContext);
                if (!notificationAction.isEnabled()) continue;
                jPopupMenu.add(new JMenuItem((Action)notificationAction));
                bl = true;
            }
            if (!bl) continue;
            ++n;
        }
        if (jPopupMenu.getComponentCount() <= 0) {
            return;
        }
        jPopupMenu.setInvoker(jComponent);
        jPopupMenu.setLocation(jComponent.getLocationOnScreen().x, jComponent.getLocationOnScreen().y + jComponent.getHeight());
        jPopupMenu.setVisible(true);
    }

    protected abstract class DisplayExtensionMenuActionListener
    implements ActionListener {
        protected DisplayExtensionMenuActionListener() {
        }

        protected abstract DefaultNotificationActionContext prepareContext(JComponent var1);

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            BaseMailNotificationWindow.this.displayExtensionMenu(this.prepareContext(jComponent), jComponent);
        }
    }

    protected class OnAccountActionListener
    extends DisplayExtensionMenuActionListener {
        protected OnAccountActionListener() {
        }

        @Override
        protected DefaultNotificationActionContext prepareContext(JComponent jComponent) {
            Account account = (Account)jComponent.getClientProperty(BaseMailNotificationWindow.PROPERTY_ACCOUNT);
            DefaultNotificationActionContext defaultNotificationActionContext = new DefaultNotificationActionContext();
            defaultNotificationActionContext.setType(NotificationExtensionType.ACCOUNT);
            defaultNotificationActionContext.setAccount(account);
            defaultNotificationActionContext.setNotificationContext(NotificationCache.getInstance());
            return defaultNotificationActionContext;
        }
    }
}

