/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.mail;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.DefaultNotificationActionContext;
import net.sf.amemailchecker.app.extension.notification.NotificationExtensionType;
import net.sf.amemailchecker.app.notification.DetailedMailNotification;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.notification.mail.AccountNotificationPanel;
import net.sf.amemailchecker.gui.notification.mail.BaseMailNotificationWindow;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;

public class DetailedMailNotificationWindow
extends BaseMailNotificationWindow<DetailedMailNotification> {
    private static final String PROPERTY_MESSAGE = "messageID";
    private static final String PROPERTY_FOLDER = "folder";
    private Map<String, ListedMessagePanel> messagePanels;
    private Map<String, Integer> messageIndexes;
    private Map<String, Map<Integer, Folder>> folderBounds;
    private static Logger logger = Logger.getLogger(DetailedMailNotificationWindow.class.getName());
    private static Icon headerIcon;
    private static Icon headerIconHighlight;

    public DetailedMailNotificationWindow(List<DetailedMailNotification> list) {
        super(list, ApplicationContext.getInstance());
    }

    protected void construct() {
        super.construct();
        this.messageIndexes = new HashMap<String, Integer>();
        this.messagePanels = new HashMap<String, ListedMessagePanel>();
        this.folderBounds = new HashMap<String, Map<Integer, Folder>>();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        for (int i = 0; i < this.notificationData.size(); ++i) {
            DetailedMailNotification detailedMailNotification = (DetailedMailNotification)this.notificationData.get(i);
            Account account = detailedMailNotification.getCommonNotificationData().getAccount();
            JPanel jPanel = this.constructAccountNotificationPanel(detailedMailNotification.getCommonNotificationData());
            boolean bl = detailedMailNotification.getCommonNotificationData().getError() != null;
            int n = detailedMailNotification.getCommonNotificationData().getUnreadCount();
            if (n <= 0 || bl) {
                this.contentPanel.add(jPanel);
                if (i >= this.notificationData.size() - 1) continue;
                this.contentPanel.add(new JSeparator(0));
                this.notificationPanels.put(account.getUuid(), jPanel);
                continue;
            }
            JPanel jPanel2 = null;
            if (n > 1) {
                jPanel2 = new JPanel();
                jPanel2.setOpaque(false);
                jPanel2.add(this.getDirectionButton(detailedMailNotification, 1));
                jPanel2.add(this.getDirectionButton(detailedMailNotification, 0));
                this.messageIndexes.put(account.getUuid(), 0);
            }
            HashMap<Integer, Folder> hashMap = new HashMap<Integer, Folder>();
            int n2 = 1;
            int n3 = 0;
            for (Folder folder : detailedMailNotification.getFolders().keySet()) {
                int n4 = detailedMailNotification.getFolders().get(folder).size();
                if (n4 == 0) continue;
                hashMap.put(n2, folder);
                hashMap.put(n3 += n4, folder);
                n2 += n4;
            }
            this.folderBounds.put(account.getUuid(), hashMap);
            ListedMessagePanel listedMessagePanel = new ListedMessagePanel(account, jPanel2, jPanel);
            this.messagePanels.put(account.getUuid(), listedMessagePanel);
            this.contentPanel.add(listedMessagePanel);
            if (i < this.notificationData.size() - 1) {
                this.contentPanel.add(new JSeparator(0));
            }
            this.updateMessageView(detailedMailNotification.getMessages().get(0), account.getUuid(), 1, detailedMailNotification.getMessages().size());
        }
    }

    private void updateMessageView(Letter letter, String string, int n, int n2) {
        this.messagePanels.get(string).updateView(letter, n, n2);
    }

    @Override
    void updateOnAccount(Account account) {
        if (!this.messagePanels.containsKey(account.getUuid())) {
            return;
        }
        ListedMessagePanel listedMessagePanel = this.messagePanels.get(account.getUuid());
        listedMessagePanel.removeDetails();
        this.contentPanel.revalidate();
        this.pack();
        this.repaint();
    }

    void updateOnFolder(Account account, Folder folder) {
        DetailedMailNotification detailedMailNotification = null;
        for (DetailedMailNotification detailedMailNotification2 : this.notificationData) {
            if (!detailedMailNotification2.getAccount().equals(account)) continue;
            detailedMailNotification = detailedMailNotification2;
            break;
        }
        if (detailedMailNotification == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (Folder folder2 : detailedMailNotification.getFolders().keySet()) {
            if (folder.equals(folder2)) {
                n2 = detailedMailNotification.getFolders().get(folder2).size();
                break;
            }
            n += detailedMailNotification.getFolders().get(folder2).size();
        }
        this.folderBounds.get(account.getUuid()).remove(n + 1);
        this.folderBounds.get(account.getUuid()).remove(n + n2);
        for (Letter letter : detailedMailNotification.getFolders().get(folder)) {
            this.updateOnMessage(account, letter.getMessageID());
        }
        detailedMailNotification.getFolders().remove(folder);
    }

    void updateOnMessage(Account account, String string) {
        DetailedMailNotification detailedMailNotification3;
        DetailedMailNotification detailedMailNotification2 = null;
        for (DetailedMailNotification detailedMailNotification3 : this.notificationData) {
            if (!detailedMailNotification3.getAccount().equals(account)) continue;
            detailedMailNotification2 = detailedMailNotification3;
            break;
        }
        if (detailedMailNotification2.getMessages().size() <= 1) {
            this.updateOnAccount(account);
            return;
        }
        int n = this.messageIndexes.get(account.getUuid());
        detailedMailNotification3 = detailedMailNotification2.getById(string);
        detailedMailNotification2.getMessages().remove(detailedMailNotification3);
        n = n >= detailedMailNotification2.getMessages().size() ? 0 : n;
        detailedMailNotification3 = detailedMailNotification2.getMessages().get(n);
        this.updateMessageView((Letter)detailedMailNotification3, account.getUuid(), n == 0 ? ++n : n, detailedMailNotification2.getMessages().size());
        if (detailedMailNotification2.getMessages().size() <= 1) {
            this.messagePanels.get(account.getUuid()).removeDirectionButtons();
        }
    }

    public JButton getDirectionButton(DetailedMailNotification detailedMailNotification, int n) {
        JButton jButton = new JButton();
        jButton.setText(n == 0 ? ">" : "<");
        jButton.addActionListener(new ListedMessageListener(n, detailedMailNotification));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setContentAreaFilled(false);
        return jButton;
    }

    static {
        try {
            BufferedImage bufferedImage = ImageIO.read(DetailedMailNotificationWindow.class.getClassLoader().getResource(ApplicationContext.getInstance().getImageIcon("icon.normal.docklet")));
            headerIcon = new ImageIcon(bufferedImage.getScaledInstance(bufferedImage.getWidth() / 3, bufferedImage.getHeight() / 3, 4));
            bufferedImage = ImageIO.read(DetailedMailNotificationWindow.class.getClassLoader().getResource(ApplicationContext.getInstance().getImageIcon("icon.envelope.normal.highlight")));
            headerIconHighlight = new ImageIcon(bufferedImage.getScaledInstance(bufferedImage.getWidth() / 3, bufferedImage.getHeight() / 3, 4));
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Cannot load icon for component!", iOException);
        }
    }

    private class HighlightMouseListener
    extends MouseAdapter {
        private HighlightMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JButton jButton = (JButton)mouseEvent.getSource();
            jButton.setIcon(headerIconHighlight);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JButton jButton = (JButton)mouseEvent.getSource();
            jButton.setIcon(headerIcon);
        }
    }

    private class OnSenderActionListener
    extends OnLetterActionListener {
        private OnSenderActionListener() {
        }

        @Override
        protected DefaultNotificationActionContext prepareContext(JComponent jComponent) {
            DefaultNotificationActionContext defaultNotificationActionContext = super.prepareContext(jComponent);
            defaultNotificationActionContext.setType(NotificationExtensionType.SENDER);
            return defaultNotificationActionContext;
        }
    }

    private class OnLetterActionListener
    extends OnFolderActionListener {
        private OnLetterActionListener() {
        }

        @Override
        protected DefaultNotificationActionContext prepareContext(JComponent jComponent) {
            DefaultNotificationActionContext defaultNotificationActionContext = super.prepareContext(jComponent);
            defaultNotificationActionContext.setType(NotificationExtensionType.LETTER);
            defaultNotificationActionContext.setLetter((Letter)jComponent.getClientProperty(DetailedMailNotificationWindow.PROPERTY_MESSAGE));
            return defaultNotificationActionContext;
        }
    }

    private class OnFolderActionListener
    extends BaseMailNotificationWindow.OnAccountActionListener {
        private OnFolderActionListener() {
        }

        @Override
        protected DefaultNotificationActionContext prepareContext(JComponent jComponent) {
            DefaultNotificationActionContext defaultNotificationActionContext = super.prepareContext(jComponent);
            Folder folder = (Folder)jComponent.getClientProperty(DetailedMailNotificationWindow.PROPERTY_FOLDER);
            defaultNotificationActionContext.setType(NotificationExtensionType.FOLDER);
            defaultNotificationActionContext.setFolder(folder);
            return defaultNotificationActionContext;
        }
    }

    private class ListedMessageListener
    implements ActionListener {
        public static final int DIRECTION_FORWARD = 0;
        public static final int DIRECTION_BACKWARD = 1;
        private int direction;
        private DetailedMailNotification notificationData;

        public ListedMessageListener(int n, DetailedMailNotification detailedMailNotification) {
            this.direction = n;
            this.notificationData = detailedMailNotification;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!DetailedMailNotificationWindow.this.interrupted) {
                DetailedMailNotificationWindow.this.interrupted = true;
            }
            JButton jButton = (JButton)actionEvent.getSource();
            Account account = this.notificationData.getCommonNotificationData().getAccount();
            int n = (Integer)DetailedMailNotificationWindow.this.messageIndexes.get(account.getUuid());
            if ((n += this.direction == 0 ? 1 : -1) >= this.notificationData.getMessages().size()) {
                n = 0;
            }
            if (n < 0) {
                n = this.notificationData.getMessages().size() - 1;
            }
            Letter letter = this.notificationData.getMessages().get(n);
            jButton.putClientProperty("currentMsgIndex", n);
            DetailedMailNotificationWindow.this.updateMessageView(letter, account.getUuid(), n + 1, this.notificationData.getMessages().size());
            DetailedMailNotificationWindow.this.messageIndexes.put(account.getUuid(), n);
        }
    }

    private class ListedMessagePanel
    extends JPanel {
        private Account account;
        private JButton senderButton;
        private JButton expandMessageButton;
        private JLabel subjectLabel;
        private JLabel indexLabel;
        private JPanel detailsPanel;
        private JPanel sidePanel;
        private JPanel innerPanel;
        private JPanel outerHeaderPanel;
        private JButton folderButton;
        JPanel buttonsPanel;

        public ListedMessagePanel(Account account, JPanel jPanel, JPanel jPanel2) {
            this.account = account;
            this.buttonsPanel = jPanel;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.senderButton = ActionControlFactory.Factory.createLinkButton();
            this.senderButton.setFont(new Font("Serif", 1, 10));
            this.senderButton.setHorizontalAlignment(2);
            this.senderButton.addActionListener(new OnSenderActionListener());
            this.expandMessageButton = new JButton(headerIcon);
            this.expandMessageButton.setMargin(new Insets(0, 0, 0, 0));
            this.expandMessageButton.setContentAreaFilled(false);
            this.expandMessageButton.setBorderPainted(false);
            this.expandMessageButton.setCursor(Cursor.getPredefinedCursor(12));
            this.expandMessageButton.addActionListener(new OnLetterActionListener());
            this.expandMessageButton.addMouseListener(new HighlightMouseListener());
            this.subjectLabel = new JLabel();
            this.subjectLabel.setHorizontalAlignment(2);
            this.subjectLabel.setFont(new Font("Serif", 2, 10));
            this.subjectLabel.setForeground(Color.RED);
            this.subjectLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            this.subjectLabel.setMinimumSize(new Dimension(100, (int)this.subjectLabel.getMinimumSize().getHeight()));
            this.indexLabel = new JLabel();
            this.indexLabel.setHorizontalAlignment(0);
            this.indexLabel.setFont(new Font("Serif", 2, 10));
            this.indexLabel.setForeground(Color.BLACK);
            this.folderButton = ActionControlFactory.Factory.createLinkButton();
            this.folderButton.setHorizontalAlignment(0);
            this.folderButton.setFont(new Font("SansSerif", 2, 10));
            this.folderButton.setForeground(Color.DARK_GRAY);
            this.folderButton.addActionListener(new OnFolderActionListener());
            this.detailsPanel = new JPanel();
            this.detailsPanel.setOpaque(false);
            this.detailsPanel.setLayout(new BoxLayout(this.detailsPanel, 1));
            this.detailsPanel.add(this.folderButton);
            this.detailsPanel.add(this.senderButton);
            this.detailsPanel.add(this.subjectLabel);
            this.outerHeaderPanel = new JPanel();
            this.outerHeaderPanel.setOpaque(false);
            this.outerHeaderPanel.setLayout(new BoxLayout(this.outerHeaderPanel, 1));
            this.outerHeaderPanel.add(jPanel2);
            this.outerHeaderPanel.add(new JSeparator(0));
            this.innerPanel = new JPanel();
            this.innerPanel.setOpaque(false);
            this.innerPanel.setLayout(new BorderLayout());
            this.innerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.innerPanel.add((Component)this.outerHeaderPanel, "North");
            this.innerPanel.add((Component)this.detailsPanel, "Center");
            this.sidePanel = new JPanel();
            this.sidePanel.setOpaque(false);
            this.sidePanel.setLayout(new BorderLayout());
            this.sidePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder("")));
            this.sidePanel.add((Component)this.indexLabel, "South");
            this.sidePanel.add((Component)this.expandMessageButton, "North");
            if (jPanel != null) {
                this.sidePanel.add((Component)jPanel, "Center");
            }
            this.add((Component)this.sidePanel, "West");
            this.add((Component)this.innerPanel, "Center");
        }

        public void updateView(Letter letter, int n, int n2) {
            Folder folder;
            this.senderButton.putClientProperty("account", this.account);
            this.senderButton.putClientProperty(DetailedMailNotificationWindow.PROPERTY_MESSAGE, letter);
            this.senderButton.setText(letter.getSender().toString());
            this.expandMessageButton.putClientProperty("account", this.account);
            this.expandMessageButton.putClientProperty(DetailedMailNotificationWindow.PROPERTY_MESSAGE, letter);
            this.folderButton.putClientProperty("account", this.account);
            this.folderButton.putClientProperty(DetailedMailNotificationWindow.PROPERTY_MESSAGE, letter);
            this.subjectLabel.setText(letter.getSubject());
            this.indexLabel.setText(n + " / " + n2);
            if (DetailedMailNotificationWindow.this.folderBounds.containsKey(this.account.getUuid()) && (folder = (Folder)((Map)DetailedMailNotificationWindow.this.folderBounds.get(this.account.getUuid())).get(n)) != null) {
                this.folderButton.setText(folder.getLabel());
                this.expandMessageButton.putClientProperty(DetailedMailNotificationWindow.PROPERTY_FOLDER, folder);
                this.senderButton.putClientProperty(DetailedMailNotificationWindow.PROPERTY_FOLDER, folder);
                this.folderButton.putClientProperty(DetailedMailNotificationWindow.PROPERTY_FOLDER, folder);
            }
            this.revalidate();
        }

        public void removeDetails() {
            AccountNotificationPanel accountNotificationPanel = (AccountNotificationPanel)this.outerHeaderPanel.getComponent(0);
            accountNotificationPanel.updateCount(0);
            accountNotificationPanel.updateInfo(0);
            this.outerHeaderPanel.removeAll();
            this.outerHeaderPanel.add(accountNotificationPanel);
            this.innerPanel.remove(this.detailsPanel);
            this.remove(this.sidePanel);
            this.revalidate();
            this.repaint();
        }

        public void removeDirectionButtons() {
            this.sidePanel.remove(this.buttonsPanel);
        }
    }
}

