/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.mail;

import java.awt.event.ActionEvent;
import java.util.List;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.app.extension.notification.NotificationAction;
import net.sf.amemailchecker.app.extension.notification.NotificationExtensionPoint;
import net.sf.amemailchecker.app.extension.notification.NotificationExtensionType;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.impl.mail.MarkAsReadFolderCommand;
import net.sf.amemailchecker.command.impl.mail.MarkAsReadMessageCommand;
import net.sf.amemailchecker.command.impl.mail.MarkDeleteFolderCommand;
import net.sf.amemailchecker.command.impl.mail.MarkDeleteMessageCommand;
import net.sf.amemailchecker.command.task.DefaultCommandExecutableTask;
import net.sf.amemailchecker.gui.notification.mail.BaseMailNotificationWindow;
import net.sf.amemailchecker.gui.notification.mail.DetailedMailNotificationWindow;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.Letter;

public class MessageOperationsNotificationExtensionPoint
implements NotificationExtensionPoint {
    private ResourceContext bundle = ApplicationContext.getInstance();

    public NotificationAction[] actions(NotificationExtensionType notificationExtensionType) {
        switch (notificationExtensionType) {
            case ACCOUNT: {
                return new NotificationAction[]{new MarkAsReadAllAction(), new MarkDeleteAllAction()};
            }
            case LETTER: {
                return new NotificationAction[]{new MarkAsReadAction(), new MarkDeleteAction()};
            }
            case FOLDER: {
                return new NotificationAction[]{new MarkAsReadFolderAction(), new MarkDeleteFolderAction()};
            }
        }
        return null;
    }

    public void shutdown() {
    }

    private class MarkDeleteFolderAction
    extends NotificationAction {
        private MarkDeleteFolderAction() {
            super(MessageOperationsNotificationExtensionPoint.this.bundle.getI18NBundleValue("action.delete.label"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Account account = this.context.getAccount();
            Folder folder = this.context.getFolder();
            List<Letter> list = NotificationCache.getInstance().get(account.getUuid(), folder);
            ((DetailedMailNotificationWindow)((Object)this.context.getInvoker())).updateOnFolder(account, folder);
            CommandExecutionService.Service.executeRegister(new DefaultCommandExecutableTask(new MarkDeleteMessageCommand(ApplicationContext.getInstance().getAccountsCache().getByUuid(account.getUuid()), folder, list.toArray(new Letter[list.size()]))));
        }
    }

    private class MarkAsReadFolderAction
    extends NotificationAction {
        private MarkAsReadFolderAction() {
            super(MessageOperationsNotificationExtensionPoint.this.bundle.getI18NBundleValue("action.mark.as.read.label"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Account account = this.context.getAccount();
            Folder folder = this.context.getFolder();
            List<Letter> list = NotificationCache.getInstance().get(account.getUuid(), folder);
            ((DetailedMailNotificationWindow)((Object)this.context.getInvoker())).updateOnFolder(account, folder);
            CommandExecutionService.Service.executeRegister(new DefaultCommandExecutableTask(new MarkAsReadMessageCommand(ApplicationContext.getInstance().getAccountsCache().getByUuid(account.getUuid()), folder, list.toArray(new Letter[list.size()]))));
        }
    }

    private class MarkDeleteAction
    extends NotificationAction {
        private MarkDeleteAction() {
            super(MessageOperationsNotificationExtensionPoint.this.bundle.getI18NBundleValue("action.delete.label"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Account account = this.context.getAccount();
            Letter letter = this.context.getLetter();
            Folder folder = this.context.getFolder();
            ((DetailedMailNotificationWindow)((Object)this.context.getInvoker())).updateOnMessage(account, letter.getMessageID());
            CommandExecutionService.Service.executeRegister(new DefaultCommandExecutableTask(new MarkDeleteMessageCommand(ApplicationContext.getInstance().getAccountsCache().getByUuid(account.getUuid()), folder, letter)));
        }
    }

    private class MarkAsReadAction
    extends NotificationAction {
        private MarkAsReadAction() {
            super(MessageOperationsNotificationExtensionPoint.this.bundle.getI18NBundleValue("action.mark.as.read.label"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Account account = this.context.getAccount();
            Letter letter = this.context.getLetter();
            Folder folder = this.context.getFolder();
            ((DetailedMailNotificationWindow)((Object)this.context.getInvoker())).updateOnMessage(account, letter.getMessageID());
            CommandExecutionService.Service.executeRegister(new DefaultCommandExecutableTask(new MarkAsReadMessageCommand(ApplicationContext.getInstance().getAccountsCache().getByUuid(account.getUuid()), folder, letter)));
        }
    }

    private class MarkDeleteAllAction
    extends NotificationAction {
        private MarkDeleteAllAction() {
            super(MessageOperationsNotificationExtensionPoint.this.bundle.getI18NBundleValue("action.delete.all.label"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Account account = this.context.getAccount();
            ((BaseMailNotificationWindow)((Object)this.context.getInvoker())).updateOnAccount(account);
            CommandExecutionService.Service.executeRegister(new DefaultCommandExecutableTask(new MarkDeleteFolderCommand(ApplicationContext.getInstance().getAccountsCache().getByUuid(account.getUuid()), NotificationCache.getInstance().get(account.getUuid()))));
        }
    }

    private class MarkAsReadAllAction
    extends NotificationAction {
        private MarkAsReadAllAction() {
            super(MessageOperationsNotificationExtensionPoint.this.bundle.getI18NBundleValue("action.mark.as.read.all.label"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Account account = this.context.getAccount();
            ((BaseMailNotificationWindow)((Object)this.context.getInvoker())).updateOnAccount(account);
            CommandExecutionService.Service.executeRegister(new DefaultCommandExecutableTask(new MarkAsReadFolderCommand(ApplicationContext.getInstance().getAccountsCache().getByUuid(account.getUuid()), NotificationCache.getInstance().get(account.getUuid()))));
        }
    }
}

