/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.notification.mail;

import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.notification.SimpleMailNotification;
import net.sf.amemailchecker.gui.notification.mail.AccountNotificationPanel;
import net.sf.amemailchecker.gui.notification.mail.BaseMailNotificationWindow;
import net.sf.amemailchecker.mail.model.Account;

public class SimpleMailNotificationWindow
extends BaseMailNotificationWindow<SimpleMailNotification> {
    public SimpleMailNotificationWindow(List<SimpleMailNotification> list) {
        super(list, ApplicationContext.getInstance());
    }

    protected void construct() {
        super.construct();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        for (int i = 0; i < this.notificationData.size(); ++i) {
            SimpleMailNotification simpleMailNotification = (SimpleMailNotification)this.notificationData.get(i);
            JPanel jPanel = this.constructAccountNotificationPanel(simpleMailNotification);
            this.contentPanel.add(jPanel);
            this.notificationPanels.put(simpleMailNotification.getAccount().getUuid(), jPanel);
            if (i >= this.notificationData.size() - 1) continue;
            this.contentPanel.add(new JSeparator(0));
        }
    }

    @Override
    void updateOnAccount(Account account) {
        AccountNotificationPanel accountNotificationPanel = (AccountNotificationPanel)this.notificationPanels.get(account.getUuid());
        accountNotificationPanel.updateCount(0);
        accountNotificationPanel.updateInfo(0);
        this.contentPanel.revalidate();
        this.pack();
        this.repaint();
    }
}

