/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.app.model.ui.UserCredentialsPanelModel;

public class AccountGeneralInfoPanelModel {
    private AccountBean account;
    private PlainDocument accountTitle;
    private PlainDocument emailAddress;
    private UserCredentialsPanelModel userCredentialsPanelModel;

    public AccountGeneralInfoPanelModel(AccountBean accountBean) {
        this.account = accountBean;
        this.userCredentialsPanelModel = new UserCredentialsPanelModel(accountBean.getUserCredentials());
        this.fill();
    }

    private void fill() {
        this.accountTitle = new PlainDocument();
        this.emailAddress = new PlainDocument();
        try {
            this.accountTitle.insertString(0, this.account.getTitle(), null);
            this.emailAddress.insertString(0, this.account.getEmailAddress(), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public AccountBean acceptUpdates() {
        try {
            this.account.setTitle(this.accountTitle.getText(0, this.accountTitle.getLength()));
            this.account.setEmailAddress(this.emailAddress.getText(0, this.emailAddress.getLength()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.account.setUserCredentials(this.userCredentialsPanelModel.acceptChanges());
        return this.account;
    }

    public PlainDocument getAccountTitle() {
        return this.accountTitle;
    }

    public PlainDocument getEmailAddress() {
        return this.emailAddress;
    }

    public UserCredentialsPanelModel getUserCredentialsPanelModel() {
        return this.userCredentialsPanelModel;
    }
}

