/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import java.awt.Window;
import java.util.List;
import javax.swing.JFrame;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.app.account.AccountServerBean;
import net.sf.amemailchecker.command.CommandErrorHandler;
import net.sf.amemailchecker.command.CommandExecutionListener;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.ICommand;
import net.sf.amemailchecker.command.exception.CommandExecutionException;
import net.sf.amemailchecker.command.impl.mail.CreateFolderCommand;
import net.sf.amemailchecker.command.impl.mail.DeleteFolderCommand;
import net.sf.amemailchecker.command.impl.mail.LoadFoldersListCommand;
import net.sf.amemailchecker.command.impl.mail.TestConnectionCommand;
import net.sf.amemailchecker.command.task.CommandExecutable;
import net.sf.amemailchecker.command.task.NotificationBlockUITask;
import net.sf.amemailchecker.gui.notification.NotificationType;
import net.sf.amemailchecker.gui.notification.NotificationWindowFactory;
import net.sf.amemailchecker.gui.settings.AccountCreationWizard;
import net.sf.amemailchecker.gui.settings.AccountInfoDialog;
import net.sf.amemailchecker.gui.settings.AccountInfoPanelModel;
import net.sf.amemailchecker.gui.settings.AccountMailBoxInfoPanelModel;
import net.sf.amemailchecker.gui.settings.SettingsMediator;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.Folder;

public class AccountInfoMediator {
    private SettingsMediator delegate;
    private AccountBean account;
    private Window window;

    public AccountInfoMediator(SettingsMediator settingsMediator) {
        this.delegate = settingsMediator;
    }

    public void testConnection(Window window, AccountBean accountBean, AccountServerBean accountServerBean) {
        NotificationBlockUITask notificationBlockUITask = new NotificationBlockUITask(new TestConnectionCommand((Account)accountBean, accountServerBean), window);
        CommandExecutionService.Service.execute(notificationBlockUITask);
    }

    public void createAccountInfo() {
        AccountCreationWizard accountCreationWizard = new AccountCreationWizard((JFrame)((Object)this.delegate.getSettingsDialog()));
        this.window = accountCreationWizard;
        this.account = this.delegate.getAccountListMediator().getAccountInfoSelected(false);
        accountCreationWizard.init(this, this.account);
        accountCreationWizard.setSize(600, 280);
        accountCreationWizard.setVisible(true);
    }

    public void editAccountInfo() {
        this.account = this.delegate.getAccountListMediator().getAccountInfoSelected(true);
        AccountInfoDialog accountInfoDialog = new AccountInfoDialog((JFrame)((Object)this.delegate.getSettingsDialog()), new AccountInfoPanelModel(this.account));
        this.window = accountInfoDialog;
        accountInfoDialog.init(this);
        accountInfoDialog.setSize(600, 280);
        accountInfoDialog.setVisible(true);
    }

    void setAccount(AccountBean accountBean) {
        this.account = accountBean;
    }

    void changeAccountInfo(AccountBean accountBean) {
        this.delegate.getAccountListMediator().changeAccountInfo(accountBean);
    }

    void loadFoldersList(final AccountMailBoxInfoPanelModel accountMailBoxInfoPanelModel) {
        this.executeFolderCommand(new LoadFoldersListCommand((Account)this.account, null), "message.unable.load.folders", new CommandExecutionListener<List<Folder>>(){

            @Override
            public void beforeExecution(CommandExecutable<List<Folder>> commandExecutable) {
            }

            @Override
            public void afterExecution(CommandExecutable<List<Folder>> commandExecutable) {
                if (!commandExecutable.isErrorOccured()) {
                    accountMailBoxInfoPanelModel.updateFoldersListModel(commandExecutable.getExecutionResult());
                }
            }
        });
    }

    void deleteFolder(Folder folder, Folder folder2, final AccountMailBoxInfoPanelModel accountMailBoxInfoPanelModel) {
        this.executeFolderCommand(new DeleteFolderCommand((Account)this.account, folder, folder2), "message.unable.delete.folder", new CommandExecutionListener<Folder>(){

            @Override
            public void beforeExecution(CommandExecutable<Folder> commandExecutable) {
            }

            @Override
            public void afterExecution(CommandExecutable<Folder> commandExecutable) {
                if (!commandExecutable.isErrorOccured()) {
                    accountMailBoxInfoPanelModel.getFolderTreeModel().delete((Object)commandExecutable.getExecutionResult());
                }
            }
        });
    }

    void createFolder(String string, final Folder folder, final AccountMailBoxInfoPanelModel accountMailBoxInfoPanelModel) {
        this.executeFolderCommand(new CreateFolderCommand((Account)this.account, string, folder), "message.unable.create.folder", new CommandExecutionListener<Folder>(){

            @Override
            public void beforeExecution(CommandExecutable<Folder> commandExecutable) {
            }

            @Override
            public void afterExecution(CommandExecutable<Folder> commandExecutable) {
                if (!commandExecutable.isErrorOccured()) {
                    accountMailBoxInfoPanelModel.getFolderTreeModel().insert((Object)folder, (Object)commandExecutable.getExecutionResult(), false);
                }
            }
        });
    }

    void executeFolderCommand(ICommand iCommand, final String string, CommandExecutionListener commandExecutionListener) {
        NotificationBlockUITask notificationBlockUITask = new NotificationBlockUITask(iCommand, this.window);
        notificationBlockUITask.addCommandExecutionListener(commandExecutionListener);
        notificationBlockUITask.addCommandErrorHandler(new CommandErrorHandler(){

            @Override
            public void handle(CommandExecutionException commandExecutionException) {
                NotificationWindowFactory.getSystemNotificationExtendedInfoWindow(ApplicationContext.getInstance().getI18NBundleValue(string), commandExecutionException.getMessage(), AccountInfoMediator.this.window).showNotification(NotificationType.ERROR);
            }
        });
        CommandExecutionService.Service.execute(notificationBlockUITask);
    }
}

