/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.gui.settings.AccountGeneralInfoPanelModel;
import net.sf.amemailchecker.gui.settings.AccountMailBoxInfoPanelModel;
import net.sf.amemailchecker.gui.settings.AccountServerInfoPanelModel;
import net.sf.amemailchecker.mail.Protocol;

public class AccountInfoPanelModel {
    private AccountBean account;
    private AccountServerInfoPanelModel ingoingServerModel;
    private AccountServerInfoPanelModel outgoingServerModel;
    private AccountGeneralInfoPanelModel accountGeneralInfoPanelModel;
    private AccountMailBoxInfoPanelModel accountMailBoxInfoPanelModel;

    public AccountInfoPanelModel(AccountBean accountBean) {
        this.account = accountBean;
        this.fill();
    }

    private void fill() {
        this.accountGeneralInfoPanelModel = new AccountGeneralInfoPanelModel(this.account);
        this.ingoingServerModel = new AccountServerInfoPanelModel(this.account.getIngoingServer());
        this.ingoingServerModel.getProtocolSelectionModel().addElement((Object)Protocol.POP3.getId(), Protocol.POP3.name());
        this.ingoingServerModel.getProtocolSelectionModel().addElement((Object)Protocol.IMAP.getId(), Protocol.IMAP.name());
        this.ingoingServerModel.getProtocolSelectionModel().setSelected((Object)this.account.getIngoingServer().getServerSettings().getProtocolType());
        this.outgoingServerModel = new AccountServerInfoPanelModel(this.account.getOutgoingServer());
        this.outgoingServerModel.getProtocolSelectionModel().addElement((Object)Protocol.SMTP.getId(), Protocol.SMTP.name());
        this.accountMailBoxInfoPanelModel = new AccountMailBoxInfoPanelModel(this.account.getMailBox(), this.account.getMailBoxPreferences());
    }

    public AccountBean acceptUpdates() {
        this.accountGeneralInfoPanelModel.acceptUpdates();
        this.account.setIngoingServer(this.ingoingServerModel.acceptChanges());
        this.account.setOutgoingServer(this.outgoingServerModel.acceptChanges());
        this.account.setMailBox(this.accountMailBoxInfoPanelModel.acceptUpdates());
        return this.account;
    }

    public AccountGeneralInfoPanelModel getGeneralInfoPanelModel() {
        return this.accountGeneralInfoPanelModel;
    }

    public AccountServerInfoPanelModel getIngoingServerModel() {
        return this.ingoingServerModel;
    }

    public AccountServerInfoPanelModel getOutgoingServerModel() {
        return this.outgoingServerModel;
    }

    public AccountMailBoxInfoPanelModel getAccountMailBoxInfoPanelModel() {
        return this.accountMailBoxInfoPanelModel;
    }
}

