/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import java.util.Collection;
import java.util.List;
import javax.swing.JToggleButton;
import net.sf.amemailchecker.gui.component.tree.CheckedValueTreeModel;
import net.sf.amemailchecker.gui.component.tree.DefaultCheckedValueTreeModel;
import net.sf.amemailchecker.gui.component.tree.TreeModelFilter;
import net.sf.amemailchecker.gui.component.tree.TreeModelHierarchyIterator;
import net.sf.amemailchecker.gui.messageviewer.foldertree.FolderTreeModelHierarchyIterator;
import net.sf.amemailchecker.mail.impl.mailbox.FolderImpl;
import net.sf.amemailchecker.mail.impl.mailbox.MailBoxImpl;
import net.sf.amemailchecker.mail.model.Folder;
import net.sf.amemailchecker.mail.model.MailBox;
import net.sf.amemailchecker.mail.model.MailBoxPreferences;

public class AccountMailBoxInfoPanelModel {
    private MailBoxImpl mailBox;
    private MailBoxPreferences preferences;
    private JToggleButton.ToggleButtonModel downloadCompleteLetterModel;
    private JToggleButton.ToggleButtonModel synchronizeFoldersAtStartupModel;
    private CheckedValueTreeModel<Folder> folderTreeModel;

    public AccountMailBoxInfoPanelModel(MailBox mailBox, MailBoxPreferences mailBoxPreferences) {
        this.mailBox = (MailBoxImpl)mailBox;
        this.preferences = mailBoxPreferences;
        this.fill();
    }

    private void fill() {
        this.downloadCompleteLetterModel = new JToggleButton.ToggleButtonModel();
        this.downloadCompleteLetterModel.setSelected(this.preferences.isDownloadCompleteLetter());
        this.synchronizeFoldersAtStartupModel = new JToggleButton.ToggleButtonModel();
        this.synchronizeFoldersAtStartupModel.setSelected(this.preferences.isSynchronizeFoldersAtStartup());
        this.folderTreeModel = new DefaultCheckedValueTreeModel();
        this.folderTreeModel.addFilter((TreeModelFilter)new TreeModelFilter<Folder>(){

            public boolean isVisible(Folder folder) {
                return folder.isSelectable();
            }
        });
        this.folderTreeModel.insert((TreeModelHierarchyIterator)new FolderTreeModelHierarchyIterator(this.mailBox.getFolders()));
    }

    public MailBoxImpl acceptUpdates() {
        for (Folder folder : this.folderTreeModel) {
            ((FolderImpl)folder).setEnabled(this.folderTreeModel.isElementSelected((Object)folder));
        }
        this.preferences.setDownloadCompleteLetter(this.downloadCompleteLetterModel.isSelected());
        this.preferences.setSynchronizeFoldersAtStartup(this.synchronizeFoldersAtStartupModel.isSelected());
        return this.mailBox;
    }

    void updateFoldersListModel(List<Folder> list) {
        Collection collection = this.folderTreeModel.getSelectedElements();
        this.mailBox.setFolders(list);
        this.folderTreeModel.clear();
        FolderTreeModelHierarchyIterator folderTreeModelHierarchyIterator = new FolderTreeModelHierarchyIterator(list);
        while (folderTreeModelHierarchyIterator.hasNext()) {
            Folder folder = (Folder)folderTreeModelHierarchyIterator.next();
            ((FolderImpl)folder).setEnabled(collection.contains(folder));
        }
        folderTreeModelHierarchyIterator.reset();
        this.folderTreeModel.insert((TreeModelHierarchyIterator)folderTreeModelHierarchyIterator);
    }

    JToggleButton.ToggleButtonModel getDownloadCompleteLetterModel() {
        return this.downloadCompleteLetterModel;
    }

    CheckedValueTreeModel<Folder> getFolderTreeModel() {
        return this.folderTreeModel;
    }

    JToggleButton.ToggleButtonModel getSynchronizeFoldersAtStartupModel() {
        return this.synchronizeFoldersAtStartupModel;
    }
}

