/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import net.sf.amemailchecker.app.account.AccountServerBean;
import net.sf.amemailchecker.app.model.ValueIDComboModel;
import net.sf.amemailchecker.app.model.ui.ServerSettingsPanelModel;
import net.sf.amemailchecker.mail.Protocol;

public class AccountServerInfoPanelModel {
    private AccountServerBean accountServerBean;
    private ValueIDComboModel<Integer> connectionSecurityModel;
    private ServerSettingsPanelModel serverSettingsPanelModel;

    public AccountServerInfoPanelModel(AccountServerBean accountServerBean) {
        this.accountServerBean = accountServerBean;
        this.serverSettingsPanelModel = new ServerSettingsPanelModel(accountServerBean.getServerSettings());
        this.fill();
    }

    private void fill() {
        this.connectionSecurityModel = new ValueIDComboModel();
        this.connectionSecurityModel.addElement((Object)Protocol.NONE.getId(), Protocol.NONE.name());
        this.connectionSecurityModel.addElement((Object)Protocol.SSL.getId(), "SSL/TLS");
        this.connectionSecurityModel.addElement((Object)Protocol.TLS.getId(), "STARTTLS");
        this.connectionSecurityModel.setSelected((Object)this.accountServerBean.getConnectionSecurity());
    }

    public AccountServerBean acceptChanges() {
        this.accountServerBean.setConnectionSecurity((Integer)this.connectionSecurityModel.getSelected());
        this.accountServerBean.setServerSettings(this.serverSettingsPanelModel.acceptChanges());
        return this.accountServerBean;
    }

    public ValueIDComboModel getConnectionSecurityModel() {
        return this.connectionSecurityModel;
    }

    public ServerSettingsPanelModel getServerSettingsPanelModel() {
        return this.serverSettingsPanelModel;
    }

    public ValueIDComboModel<Integer> getProtocolSelectionModel() {
        return this.getServerSettingsPanelModel().getProtocolSelectionModel();
    }
}

