/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.app.extension.ExtensionInfo;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.impl.app.OpenWebAddressCommand;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageDetailsEditState;
import net.sf.amemailchecker.gui.messageviewer.messagedetails.MessageDetailsMediator;
import net.sf.amemailchecker.util.StringUtil;

public class ExtensionInfoPanel
extends JPanel {
    private JLabel author;
    private JLabel version;
    private JLabel description;
    private JButton homePage;
    private JButton email;
    private ResourceContext resourceContext = ApplicationContext.getInstance();
    private String notProvidedTxt;

    public ExtensionInfoPanel() {
        GridLayout gridLayout = new GridLayout(2, 1);
        gridLayout.setVgap(10);
        this.setLayout(gridLayout);
        this.notProvidedTxt = this.resourceContext.getI18NBundleValue("label.extension.version");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 2));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(new JLabel(this.resourceContext.getI18NBundleValue("label.extension.version")));
        this.version = new JLabel();
        this.version.setHorizontalAlignment(0);
        jPanel.add(this.version);
        jPanel.add(new JLabel(this.resourceContext.getI18NBundleValue("label.extension.author")));
        this.author = new JLabel();
        this.author.setHorizontalAlignment(0);
        jPanel.add(this.author);
        jPanel.add(new JLabel(this.resourceContext.getI18NBundleValue("label.email")));
        this.email = ActionControlFactory.Factory.createLinkButton();
        this.email.setHorizontalAlignment(4);
        jPanel.add(this.email);
        this.email.addActionListener(new EmailActionListener());
        jPanel.add(new JLabel(this.resourceContext.getI18NBundleValue("label.extension.homepage")));
        this.homePage = ActionControlFactory.Factory.createLinkButton();
        this.homePage.setHorizontalAlignment(4);
        jPanel.add(this.homePage);
        this.homePage.addActionListener(new HomePageActionListener());
        this.description = new JLabel();
        this.description.setHorizontalAlignment(0);
        this.add(jPanel);
        this.add(ActionControlFactory.Factory.createTitleWrapper((JComponent)this.description, this.resourceContext.getI18NBundleValue("label.description")));
        Font font = new Font(this.author.getFont().getName(), 0, this.author.getFont().getSize());
        this.author.setFont(font);
        this.version.setFont(font);
        this.email.setFont(font);
        this.homePage.setFont(font);
        this.description.setFont(font);
    }

    void update(ExtensionInfo extensionInfo) {
        this.author.setText(this.getLabelText(extensionInfo.getAuthor()));
        this.version.setText(this.getLabelText(extensionInfo.getVersion()));
        this.email.setText(this.getLabelText(extensionInfo.getEmail()));
        this.homePage.setText(this.getLabelText(extensionInfo.getHomePage()));
        this.description.setText(this.getLabelText(ApplicationContext.getInstance().getI18NBundleValue(extensionInfo.getName(), extensionInfo.getDescriptionBundleKey())));
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE) || this.homePage.getText().equals(this.notProvidedTxt)) {
            this.homePage.setEnabled(false);
        }
        if (this.email.getText().equals(this.notProvidedTxt)) {
            this.email.setEnabled(false);
        }
    }

    private String getLabelText(String string) {
        return StringUtil.isNullOrEmpty((String)string) ? this.notProvidedTxt : string;
    }

    private class HomePageActionListener
    implements ActionListener {
        private HomePageActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CommandExecutionService.Service.executeCommandSilent(new OpenWebAddressCommand(((JButton)actionEvent.getSource()).getText()));
        }
    }

    private class EmailActionListener
    implements ActionListener {
        private EmailActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new MessageDetailsMediator().expandLetterToEdit(ExtensionInfoPanel.this.author.getText(), ExtensionInfoPanel.this.email.getText(), MessageDetailsEditState.COMPOSE_NEW);
        }
    }
}

