/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.settings.ExtensionInfoPanel;
import net.sf.amemailchecker.gui.settings.ExtensionModelChangeListener;
import net.sf.amemailchecker.gui.settings.ExtensionsPanelModel;
import net.sf.amemailchecker.gui.settings.SettingsMediator;

public class ExtensionsPanel
extends JPanel {
    private JList extensionsList;
    private JPanel extSettingsPanel;
    private JLabel noExtSettingsInfo;
    private ExtensionInfoPanel extInfoPanel;
    private JTabbedPane tabbedPane;
    private ExtensionsPanelModel model;
    private ExtensionModelChangeListener listener;

    public ExtensionsPanel(SettingsMediator settingsMediator, ExtensionsPanelModel extensionsPanelModel) {
        this.model = extensionsPanelModel;
        this.listener = new ExtensionModelChangeListener(settingsMediator);
    }

    public void init() {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        this.setLayout(new BorderLayout());
        if (this.model.size() <= 0) {
            this.noExtSettingsInfo = new JLabel(applicationContext.getI18NBundleValue("message.no.extensions"));
            this.noExtSettingsInfo.setHorizontalAlignment(0);
            this.add((Component)this.noExtSettingsInfo, "Center");
            return;
        }
        this.noExtSettingsInfo = new JLabel(applicationContext.getI18NBundleValue("message.extension.no.settings"));
        this.tabbedPane = new JTabbedPane();
        this.extSettingsPanel = new JPanel();
        this.extSettingsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.extSettingsPanel.setLayout(new GridBagLayout());
        this.extInfoPanel = new ExtensionInfoPanel();
        this.extensionsList = new JList(this.model.getExtensionsListModel());
        this.extensionsList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.extensionsList.setCellRenderer(new ExtensionListCellRenderer());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.extensionsList);
        this.add((Component)jScrollPane, "West");
        this.extensionsList.addMouseListener(new ExtensionListMouseListener());
        this.tabbedPane.addTab(applicationContext.getI18NBundleValue("label.extension.info"), ActionControlFactory.Factory.createScrollWrapper((JComponent)this.extInfoPanel));
        this.tabbedPane.addTab(applicationContext.getI18NBundleValue("label.preferences"), ActionControlFactory.Factory.createScrollWrapper((JComponent)this.extSettingsPanel));
        this.add((Component)this.tabbedPane, "Center");
    }

    private class ExtensionListCellRenderer
    extends DefaultListCellRenderer {
        private ExtensionListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            this.setForeground(bl ? Color.LIGHT_GRAY : Color.BLUE);
            this.setBackground(jList.getBackground());
            return this;
        }
    }

    private class ExtensionListMouseListener
    extends MouseAdapter {
        private ExtensionListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            String string = (String)ExtensionsPanel.this.extensionsList.getSelectedValue();
            JPanel jPanel = ExtensionsPanel.this.model.getExtensionUI(string, ExtensionsPanel.this.listener);
            ExtensionsPanel.this.extInfoPanel.update(ExtensionsPanel.this.model.getExtensionInfo(string));
            ExtensionsPanel.this.extSettingsPanel.removeAll();
            if (jPanel != null) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 11;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                ExtensionsPanel.this.extSettingsPanel.add((Component)jPanel, gridBagConstraints);
            } else {
                ExtensionsPanel.this.extSettingsPanel.add(ExtensionsPanel.this.noExtSettingsInfo);
            }
            ExtensionsPanel.this.extSettingsPanel.revalidate();
            ExtensionsPanel.this.extSettingsPanel.repaint();
        }
    }
}

