/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import net.sf.amemailchecker.app.extension.ExtensionInfo;
import net.sf.amemailchecker.app.extension.ExtensionSettings;
import net.sf.amemailchecker.gui.settings.ExtensionModelChangeListener;

public class ExtensionsPanelModel {
    private List<ExtensionInfo> extensions;
    private Map<String, ExtensionInfo> extensionsMap;
    private DefaultListModel extensionsListModel;
    private Map<String, JPanel> extUiPanels;

    public ExtensionsPanelModel(List<ExtensionInfo> list) {
        this.extensions = list;
        this.init();
    }

    public void init() {
        this.extensionsMap = new HashMap<String, ExtensionInfo>();
        this.extUiPanels = new HashMap<String, JPanel>();
        this.extensionsListModel = new DefaultListModel();
        for (int i = 0; i < this.extensions.size(); ++i) {
            ExtensionInfo extensionInfo = this.extensions.get(i);
            if (extensionInfo.isSmooth()) continue;
            this.extensionsListModel.addElement(extensionInfo.getName());
            this.extensionsMap.put(extensionInfo.getName(), extensionInfo);
        }
    }

    public DefaultListModel getExtensionsListModel() {
        return this.extensionsListModel;
    }

    public ExtensionInfo getExtensionInfo(String string) {
        return this.extensionsMap.get(string);
    }

    public JPanel getExtensionUI(String string, ExtensionModelChangeListener extensionModelChangeListener) {
        ExtensionSettings extensionSettings;
        JPanel jPanel = this.extUiPanels.get(string);
        if (jPanel == null && (extensionSettings = this.extensionsMap.get(string).getExtension().settings()) != null) {
            jPanel = extensionSettings.settingsUI();
            jPanel.addPropertyChangeListener(extensionModelChangeListener);
            this.extUiPanels.put(string, jPanel);
        }
        return jPanel;
    }

    public int size() {
        return this.extensionsMap.size();
    }
}

