/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.component.list.CheckedValueListCellRenderer;
import net.sf.amemailchecker.gui.component.list.CheckedValueListMouseListener;
import net.sf.amemailchecker.gui.settings.ApplyStateListener;
import net.sf.amemailchecker.gui.settings.PersonalDataPanelModel;
import net.sf.amemailchecker.gui.settings.SettingsMediator;

public class PersonalDataPanel
extends JPanel {
    private JTextField name;
    private JTextField surname;
    private JCheckBox surnameFirst;
    private JList signatureList;
    private SettingsMediator mediator;

    public PersonalDataPanel(SettingsMediator settingsMediator) {
        this.mediator = settingsMediator;
    }

    public void init(PersonalDataPanelModel personalDataPanelModel) {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(3, 2);
        gridLayout.setVgap(5);
        jPanel.setLayout(gridLayout);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(applicationContext.getI18NBundleValue("label.person.identity")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel.add(new JLabel(applicationContext.getI18NBundleValue("label.person.name")));
        this.name = new JTextField();
        this.name.setDocument(personalDataPanelModel.getPersonIdentityModel().getNameModel());
        jPanel.add(this.name);
        jPanel.add(new JLabel(applicationContext.getI18NBundleValue("label.person.surname")));
        this.surname = new JTextField();
        this.surname.setDocument(personalDataPanelModel.getPersonIdentityModel().getSurnameModel());
        jPanel.add(this.surname);
        jPanel.add(new JLabel(applicationContext.getI18NBundleValue("label.surname.first")));
        this.surnameFirst = new JCheckBox();
        this.surnameFirst.setModel(personalDataPanelModel.getPersonIdentityModel().getSurnameFirstModel());
        jPanel.add(this.surnameFirst);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(applicationContext.getI18NBundleValue("label.signatures")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.signatureList = new JList();
        this.signatureList.setModel(personalDataPanelModel.getSignatureListModel());
        this.signatureList.setCellRenderer(new CheckedValueListCellRenderer.RadioListCellRenderer(true));
        this.signatureList.addMouseListener((MouseListener)new CheckedValueListMouseListener());
        this.signatureList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    PersonalDataPanel.this.mediator.getSignatureMediator().editSignature(PersonalDataPanel.this.signatureList.getSelectedIndex());
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.signatureList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        jPanel3.setLayout(new GridBagLayout());
        ActionControlFactory actionControlFactory = ActionControlFactory.Factory;
        JButton jButton = actionControlFactory.createSimpleActionButton(applicationContext.loadImageIcon("icon.add"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PersonalDataPanel.this.mediator.getSignatureMediator().createSignature();
            }
        });
        JButton jButton2 = actionControlFactory.createSimpleActionButton(applicationContext.loadImageIcon("icon.delete"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PersonalDataPanel.this.signatureList.getSelectedIndex();
                PersonalDataPanel.this.mediator.getSignatureMediator().removeSignature(n);
                ((DefaultListModel)PersonalDataPanel.this.signatureList.getModel()).removeElementAt(n);
            }
        });
        JButton jButton3 = actionControlFactory.createSimpleActionButton(applicationContext.loadImageIcon("icon.edit"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PersonalDataPanel.this.mediator.getSignatureMediator().editSignature(PersonalDataPanel.this.signatureList.getSelectedIndex());
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        jPanel3.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel3.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel3.add((Component)jButton3, gridBagConstraints);
        jPanel2.add((Component)jPanel3, "East");
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel);
        this.add(jPanel2);
        ApplyStateListener applyStateListener = new ApplyStateListener(this.mediator);
        this.name.getDocument().addDocumentListener(applyStateListener);
        this.surname.getDocument().addDocumentListener(applyStateListener);
        this.surnameFirst.addActionListener(applyStateListener);
        this.signatureList.getModel().addListDataListener(applyStateListener);
    }
}

