/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import java.util.HashMap;
import java.util.Map;
import net.sf.amemailchecker.app.model.PersonSignature;
import net.sf.amemailchecker.app.model.PersonalData;
import net.sf.amemailchecker.app.model.UIPanelModel;
import net.sf.amemailchecker.app.model.ui.PersonIdentityPanelModel;
import net.sf.amemailchecker.app.model.ui.PersonalSignaturePanelModel;
import net.sf.amemailchecker.gui.component.list.CheckedValueListModel;
import net.sf.amemailchecker.gui.component.list.DefaultCheckedValueListModel;

public class PersonalDataPanelModel
implements UIPanelModel<PersonalData> {
    private PersonalData personalData;
    private PersonIdentityPanelModel personIdentityModel;
    private CheckedValueListModel<PersonSignature> signatureListModel;
    private Map<String, PersonalSignaturePanelModel> signatureModelMap;

    public PersonalDataPanelModel(PersonalData personalData) {
        this.personIdentityModel = new PersonIdentityPanelModel(personalData.getPersonIdentity());
        this.signatureListModel = new DefaultCheckedValueListModel();
        this.signatureListModel.setUseSingleSelection(true);
        this.signatureModelMap = new HashMap<String, PersonalSignaturePanelModel>();
        this.fireModelUpdate(personalData);
    }

    public void fill() {
        PersonSignature personSignature = this.personalData.getDefaultSignature();
        Map<String, PersonSignature> map = this.personalData.getSignatures();
        this.signatureListModel.clear();
        this.signatureListModel.addElements(map.values(), (Object[])new PersonSignature[]{personSignature});
        this.signatureModelMap.clear();
        for (PersonSignature personSignature2 : map.values()) {
            this.signatureModelMap.put(personSignature2.getUuid(), new PersonalSignaturePanelModel(personSignature2));
        }
    }

    public PersonalData acceptChanges() {
        this.personalData.setPersonIdentity(this.personIdentityModel.acceptChanges());
        for (String string : this.signatureModelMap.keySet()) {
            PersonSignature personSignature = this.signatureModelMap.get(string).acceptChanges();
            personSignature.setUuid(string);
            this.personalData.getSignatures().put(string, personSignature);
        }
        this.personalData.getSignatures().keySet().retainAll(this.signatureModelMap.keySet());
        if (this.signatureListModel.getSelectedValues().size() > 0) {
            this.personalData.setDefaultSignature((PersonSignature)this.signatureListModel.getSelectedValues().get(0));
        }
        return this.personalData;
    }

    public PersonalData declineChanges() {
        this.personalData.setPersonIdentity(this.personIdentityModel.declineChanges());
        return this.personalData;
    }

    public void fireModelUpdate(PersonalData personalData) {
        this.personalData = personalData;
        this.personIdentityModel.fireModelUpdate(personalData.getPersonIdentity());
        this.fill();
    }

    public PersonIdentityPanelModel getPersonIdentityModel() {
        return this.personIdentityModel;
    }

    public CheckedValueListModel<PersonSignature> getSignatureListModel() {
        return this.signatureListModel;
    }

    public PersonalSignaturePanelModel getSignatureModel(String string) {
        return this.signatureModelMap.get(string);
    }

    public void addSignatureModel(String string, PersonalSignaturePanelModel personalSignaturePanelModel) {
        this.signatureModelMap.put(string, personalSignaturePanelModel);
    }

    public void removeSignatureModel(String string) {
        this.signatureModelMap.remove(string);
    }
}

