/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.gui.settings.ApplyStateListener;
import net.sf.amemailchecker.gui.settings.ProxySettingsPanelModel;

public class ProxySettingsPanel
extends JPanel {
    private JCheckBox useProxy;
    private JCheckBox useAuthentication;
    private JTextField host;
    private JTextField port;
    private JTextField userName;
    private JPasswordField password;
    private JComboBox protocol;

    public ProxySettingsPanel(ProxySettingsPanelModel proxySettingsPanelModel, ApplyStateListener applyStateListener) {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)new JLabel(applicationContext.getI18NBundleValue("label.proxy.use")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.useProxy = new JCheckBox();
        this.useProxy.setModel(proxySettingsPanelModel.getUseProxyModel());
        this.add((Component)this.useProxy, gridBagConstraints);
        this.useProxy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ProxySettingsPanel.this.useProxyState(ProxySettingsPanel.this.useProxy.isSelected());
            }
        });
        gridBagConstraints.gridy = 1;
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)new JLabel(applicationContext.getI18NBundleValue("label.proxy.type")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.protocol = new JComboBox<Integer>((ComboBoxModel<Integer>)proxySettingsPanelModel.getServerSettingsPanelModel().getProtocolSelectionModel());
        this.add((Component)this.protocol, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)new JLabel(applicationContext.getI18NBundleValue("label.host")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.host = new JTextField();
        this.host.setDocument(proxySettingsPanelModel.getServerSettingsPanelModel().getHostModel());
        this.add((Component)this.host, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.add((Component)new JLabel(applicationContext.getI18NBundleValue("label.port")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.port = new JTextField();
        this.port.setDocument(proxySettingsPanelModel.getServerSettingsPanelModel().getPortModel());
        this.add((Component)this.port, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        this.add((Component)new JLabel(applicationContext.getI18NBundleValue("label.use.auth")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        this.useAuthentication = new JCheckBox();
        this.useAuthentication.setModel(proxySettingsPanelModel.getUseAuthenticationModel());
        this.add((Component)this.useAuthentication, gridBagConstraints);
        this.useAuthentication.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ProxySettingsPanel.this.useAuthenticationState(ProxySettingsPanel.this.useAuthentication.isSelected());
            }
        });
        gridBagConstraints.gridy = 9;
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        this.add((Component)new JLabel(applicationContext.getI18NBundleValue("label.username")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        this.userName = new JTextField();
        this.userName.setDocument(proxySettingsPanelModel.getUserCredentialsPanelModel().getUserNameModel());
        this.add((Component)this.userName, gridBagConstraints);
        gridBagConstraints.gridy = 11;
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        this.add((Component)new JLabel(applicationContext.getI18NBundleValue("label.password")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        this.password = new JPasswordField();
        this.password.setDocument(proxySettingsPanelModel.getUserCredentialsPanelModel().getPasswordModel());
        this.add((Component)this.password, gridBagConstraints);
        this.useProxyState(this.useProxy.isSelected());
        this.useProxy.addActionListener(applyStateListener);
        this.protocol.addActionListener(applyStateListener);
        this.host.getDocument().addDocumentListener(applyStateListener);
        this.port.getDocument().addDocumentListener(applyStateListener);
        this.useAuthentication.addActionListener(applyStateListener);
        this.userName.getDocument().addDocumentListener(applyStateListener);
        this.password.getDocument().addDocumentListener(applyStateListener);
    }

    private void useProxyState(boolean bl) {
        this.host.setEnabled(bl);
        this.port.setEnabled(bl);
        this.protocol.setEnabled(bl);
        this.useAuthentication.setEnabled(bl);
        this.useAuthenticationState(bl ? this.useAuthentication.isSelected() : this.useAuthentication.isEnabled());
    }

    private void useAuthenticationState(boolean bl) {
        this.userName.setEnabled(bl);
        this.password.setEnabled(bl);
    }
}

