/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import javax.swing.JToggleButton;
import net.sf.amemailchecker.app.model.ProxySettings;
import net.sf.amemailchecker.app.model.UIPanelModel;
import net.sf.amemailchecker.app.model.ui.ServerSettingsPanelModel;
import net.sf.amemailchecker.app.model.ui.UserCredentialsPanelModel;
import net.sf.amemailchecker.mail.Protocol;

public class ProxySettingsPanelModel
implements UIPanelModel<ProxySettings> {
    private ProxySettings proxySettings;
    private ProxySettings origProxySettings;
    private ServerSettingsPanelModel serverSettingsPanelModel;
    private UserCredentialsPanelModel userCredentialsPanelModel;
    private JToggleButton.ToggleButtonModel useProxyModel;
    private JToggleButton.ToggleButtonModel useAuthenticationModel;

    public ProxySettingsPanelModel(ProxySettings proxySettings) {
        this.serverSettingsPanelModel = new ServerSettingsPanelModel(proxySettings.getServerSettings());
        this.userCredentialsPanelModel = new UserCredentialsPanelModel(proxySettings.getUserCredentials());
        this.useProxyModel = new JToggleButton.ToggleButtonModel();
        this.useAuthenticationModel = new JToggleButton.ToggleButtonModel();
        this.fireModelUpdate(proxySettings);
    }

    public void fill() {
        this.useProxyModel.setSelected(this.proxySettings.isUseProxy());
        this.useAuthenticationModel.setSelected(this.proxySettings.isUseAuthentication());
        this.serverSettingsPanelModel.getProtocolSelectionModel().removeAllElements();
        this.serverSettingsPanelModel.getProtocolSelectionModel().addElement((Object)Protocol.SOCKS.getId(), Protocol.SOCKS.name());
        this.serverSettingsPanelModel.getProtocolSelectionModel().addElement((Object)Protocol.HTTP.getId(), Protocol.HTTP.name());
        this.serverSettingsPanelModel.getProtocolSelectionModel().setSelected((Object)this.proxySettings.getServerSettings().getProtocolType());
    }

    public ProxySettings acceptChanges() {
        this.proxySettings.setUseProxy(this.useProxyModel.isSelected());
        this.proxySettings.setUseAuthentication(this.useAuthenticationModel.isSelected());
        this.proxySettings.setServerSettings(this.serverSettingsPanelModel.acceptChanges());
        this.proxySettings.setUserCredentials(this.userCredentialsPanelModel.acceptChanges());
        return this.proxySettings;
    }

    public ProxySettings declineChanges() {
        return this.origProxySettings;
    }

    public void fireModelUpdate(ProxySettings proxySettings) {
        this.proxySettings = new ProxySettings(proxySettings);
        this.origProxySettings = proxySettings;
        this.serverSettingsPanelModel.fireModelUpdate(proxySettings.getServerSettings());
        this.userCredentialsPanelModel.fireModelUpdate(proxySettings.getUserCredentials());
        this.fill();
    }

    JToggleButton.ToggleButtonModel getUseProxyModel() {
        return this.useProxyModel;
    }

    JToggleButton.ToggleButtonModel getUseAuthenticationModel() {
        return this.useAuthenticationModel;
    }

    public ServerSettingsPanelModel getServerSettingsPanelModel() {
        return this.serverSettingsPanelModel;
    }

    public UserCredentialsPanelModel getUserCredentialsPanelModel() {
        return this.userCredentialsPanelModel;
    }
}

