/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.BaseFrame;
import net.sf.amemailchecker.gui.settings.SettingsMainPanel;
import net.sf.amemailchecker.gui.settings.SettingsMediator;
import net.sf.amemailchecker.gui.settings.accounts.AccountListMenu;

public class SettingsDialog
extends BaseFrame {
    private SettingsMediator mediator;
    private JButton apply;
    private JButton accept;
    private JButton cancel;

    public SettingsDialog(SettingsMediator settingsMediator) {
        this.mediator = settingsMediator;
    }

    public void init() {
        super.init((ResourceContext)ApplicationContext.getInstance());
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        this.setTitle(applicationContext.getI18NBundleValue("dialog.settings.title"));
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(applicationContext.getI18NBundleValue("action.file"));
        jMenu.add(ActionControlFactory.Factory.getJMenuItem(applicationContext.getI18NBundleValue("action.save"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.mediator.writeSettings();
            }
        }));
        jMenu.add(ActionControlFactory.Factory.getJMenuItem(applicationContext.getI18NBundleValue("action.import.settings"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.mediator.importSettings();
            }
        }));
        jMenu.add(ActionControlFactory.Factory.getJMenuItem(applicationContext.getI18NBundleValue("action.export.settings"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.mediator.exportSettings();
            }
        }));
        jMenu.addSeparator();
        jMenu.add(ActionControlFactory.Factory.getJMenuItem(applicationContext.getI18NBundleValue("action.close.label"), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.mediator.declineSettingsChanges();
                SettingsDialog.this.setVisible(false);
                ApplicationContext.getInstance().removeObject(SettingsMediator.class.getName());
            }
        }));
        jMenuBar.add(jMenu);
        jMenuBar.add(new AccountListMenu(applicationContext.getI18NBundleValue("label.accounts"), this.mediator.getAccountListMediator()));
        this.setJMenuBar(jMenuBar);
        this.cancel = new JButton();
        this.cancel.setText(applicationContext.getI18NBundleValue("action.cancel.label"));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.mediator.declineSettingsChanges();
                SettingsDialog.this.setVisible(false);
                ApplicationContext.getInstance().removeObject(SettingsMediator.class.getName());
            }
        });
        this.accept = new JButton();
        this.accept.setText(applicationContext.getI18NBundleValue("action.accept.label"));
        this.accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.mediator.acceptSettingsChanges();
                SettingsDialog.this.mediator.writeSettings();
                SettingsDialog.this.setVisible(false);
                ApplicationContext.getInstance().removeObject(SettingsMediator.class.getName());
            }
        });
        this.apply = new JButton();
        this.apply.setText(applicationContext.getI18NBundleValue("action.apply.label"));
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SettingsDialog.this.mediator.acceptSettingsChanges();
                SettingsDialog.this.changeApplyState(false);
            }
        });
        this.changeApplyState(false);
        JPanel jPanel = new JPanel();
        jPanel.add(this.accept);
        jPanel.add(this.cancel);
        jPanel.add(this.apply);
        SettingsMainPanel settingsMainPanel = new SettingsMainPanel(this.mediator);
        settingsMainPanel.init();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)settingsMainPanel, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SettingsDialog.this.mediator.declineSettingsChanges();
                ApplicationContext.getInstance().removeObject(SettingsMediator.class.getName());
            }
        });
    }

    void changeApplyState(boolean bl) {
        this.apply.setEnabled(bl);
    }
}

