/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.gui.ActionControlFactory;
import net.sf.amemailchecker.gui.settings.ApplyStateListener;
import net.sf.amemailchecker.gui.settings.ExtensionsPanel;
import net.sf.amemailchecker.gui.settings.PersonalDataPanel;
import net.sf.amemailchecker.gui.settings.ProxySettingsPanel;
import net.sf.amemailchecker.gui.settings.SettingsMediator;
import net.sf.amemailchecker.gui.settings.SettingsPanelModel;
import net.sf.amemailchecker.gui.settings.accounts.AccountList;
import net.sf.amemailchecker.gui.settings.preferences.MessageViewerPreferencesPanel;
import net.sf.amemailchecker.gui.settings.preferences.NotificationPreferencesPanel;
import net.sf.amemailchecker.gui.settings.preferences.UserPreferencesPanel;

public class SettingsMainPanel
extends JTabbedPane {
    private SettingsMediator mediator;

    SettingsMainPanel(SettingsMediator settingsMediator) {
        this.mediator = settingsMediator;
    }

    void init() {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        AccountList accountList = this.mediator.getAccountListMediator().getAccountList();
        ((JList)accountList).getModel().addListDataListener(new ApplyStateListener(this.mediator));
        JScrollPane jScrollPane = ActionControlFactory.Factory.createScrollWrapper((JComponent)accountList);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(applicationContext.getI18NBundleValue("label.accounts"))));
        jPanel.add((Component)jScrollPane, "Center");
        this.addTab(applicationContext.getI18NBundleValue("label.accounts"), jPanel);
        ApplyStateListener applyStateListener = new ApplyStateListener(this.mediator);
        SettingsPanelModel settingsPanelModel = this.mediator.getSettingsPanelModel();
        JTabbedPane jTabbedPane = new JTabbedPane(2);
        jTabbedPane.addTab(applicationContext.getI18NBundleValue("panel.account.general.settings"), new UserPreferencesPanel(settingsPanelModel.getUserPreferencesPanelModel(), applyStateListener));
        jTabbedPane.addTab(applicationContext.getI18NBundleValue("panel.settings.notification.label"), new NotificationPreferencesPanel(settingsPanelModel.getUserPreferencesPanelModel(), applyStateListener));
        jTabbedPane.addTab(applicationContext.getI18NBundleValue("dialog.message.viewer.title"), new MessageViewerPreferencesPanel(settingsPanelModel.getMessageViewerPreferencesPanelModel(), applyStateListener));
        JLabel jLabel = new JLabel(applicationContext.getI18NBundleValue("message.app.restart.required"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)ActionControlFactory.Factory.createScrollWrapper((JComponent)jTabbedPane), "Center");
        jPanel2.add((Component)jLabel, "South");
        this.addTab(applicationContext.getI18NBundleValue("label.preferences"), jPanel2);
        this.addTab(applicationContext.getI18NBundleValue("label.proxy.settings"), new ProxySettingsPanel(this.mediator.getProxySettingsPanelModel(), applyStateListener));
        PersonalDataPanel personalDataPanel = new PersonalDataPanel(this.mediator);
        personalDataPanel.init(this.mediator.getPersonalDataModel());
        this.addTab(applicationContext.getI18NBundleValue("label.personal.settings"), ActionControlFactory.Factory.createScrollWrapper((JComponent)personalDataPanel));
        ExtensionsPanel extensionsPanel = new ExtensionsPanel(this.mediator, this.mediator.getExtensionsPanelModel());
        extensionsPanel.init();
        this.addTab(applicationContext.getI18NBundleValue("label.extensions.settings"), extensionsPanel);
    }
}

