/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.extension.ExtensionInfo;
import net.sf.amemailchecker.app.extension.ExtensionLoader;
import net.sf.amemailchecker.app.extension.ExtensionProvider;
import net.sf.amemailchecker.app.extension.ExtensionSettings;
import net.sf.amemailchecker.app.model.PersonalData;
import net.sf.amemailchecker.app.model.ProxySettings;
import net.sf.amemailchecker.app.model.UserData;
import net.sf.amemailchecker.app.model.UserPreferences;
import net.sf.amemailchecker.command.CommandExecutionListener;
import net.sf.amemailchecker.command.CommandExecutionService;
import net.sf.amemailchecker.command.impl.app.ExportSettingsCommand;
import net.sf.amemailchecker.command.impl.app.ImportSettingsCommand;
import net.sf.amemailchecker.command.impl.app.SaveSettingsCommand;
import net.sf.amemailchecker.command.task.CommandExecutable;
import net.sf.amemailchecker.command.task.NotificationBlockUITask;
import net.sf.amemailchecker.gui.entrypoint.EntryPointMediator;
import net.sf.amemailchecker.gui.messageviewer.MessageViewer;
import net.sf.amemailchecker.gui.messageviewer.MessageViewerPreferences;
import net.sf.amemailchecker.gui.settings.AccountInfoMediator;
import net.sf.amemailchecker.gui.settings.ExtensionsPanelModel;
import net.sf.amemailchecker.gui.settings.PersonalDataPanelModel;
import net.sf.amemailchecker.gui.settings.ProxySettingsPanelModel;
import net.sf.amemailchecker.gui.settings.SettingsDialog;
import net.sf.amemailchecker.gui.settings.SettingsPanelModel;
import net.sf.amemailchecker.gui.settings.SignatureMediator;
import net.sf.amemailchecker.gui.settings.accounts.AccountList;
import net.sf.amemailchecker.gui.settings.accounts.AccountListMediator;
import net.sf.amemailchecker.gui.settings.preferences.MessageViewerPreferencesPanelModel;
import net.sf.amemailchecker.gui.settings.preferences.UserPreferencesPanelModel;
import net.sf.amemailchecker.mail.cache.PostalAddresseeCache;
import net.sf.amemailchecker.proxy.ProxyDispatcher;

public class SettingsMediator {
    private static final Logger logger = Logger.getLogger(SettingsMediator.class.getName());
    private SettingsDialog settingsDialog;
    private AccountListMediator accountListMediator;
    private AccountInfoMediator accountInfoMediator;
    private EntryPointMediator entryPointMediator;
    private SettingsPanelModel settingsPanelModel;
    private ProxySettingsPanelModel proxySettingsPanelModel;
    private PersonalDataPanelModel personalDataModel;
    private SignatureMediator signatureMediator;
    private ExtensionsPanelModel extensionsPanelModel;
    private MessageViewerPreferencesPanelModel messageViewerPreferencesPanelModel;
    private UserPreferencesPanelModel userPreferencesPanelModel;

    public SettingsMediator(EntryPointMediator entryPointMediator) {
        this.entryPointMediator = entryPointMediator;
        this.accountListMediator = new AccountListMediator(this);
        AccountList accountList = new AccountList(this.accountListMediator);
        this.settingsDialog = new SettingsDialog(this);
        this.signatureMediator = new SignatureMediator(this);
        this.accountInfoMediator = new AccountInfoMediator(this);
        accountList.init();
    }

    public void showSettingsDialog() {
        UserData userData = ApplicationContext.getInstance().getUserData();
        this.messageViewerPreferencesPanelModel = new MessageViewerPreferencesPanelModel(userData.getMessageViewerPreferences());
        this.userPreferencesPanelModel = new UserPreferencesPanelModel(userData.getPreferences());
        this.settingsPanelModel = new SettingsPanelModel(this.messageViewerPreferencesPanelModel, this.userPreferencesPanelModel);
        this.proxySettingsPanelModel = new ProxySettingsPanelModel(userData.getProxySettings());
        this.personalDataModel = new PersonalDataPanelModel(userData.getPersonalData());
        this.extensionsPanelModel = new ExtensionsPanelModel(ExtensionProvider.Provider.getExtensions());
        this.settingsDialog.init();
        this.settingsDialog.setSize(680, 460);
        this.settingsDialog.setVisible(true);
    }

    public void declineSettingsChanges() {
        this.accountListMediator.declineUpdates();
        this.settingsChanged(false);
    }

    public void acceptSettingsChanges() {
        this.accountListMediator.acceptUpdates();
        this.settingsChanged(true);
    }

    private void settingsChanged(boolean bl) {
        boolean bl2;
        UserPreferences userPreferences = bl ? this.userPreferencesPanelModel.acceptChanges() : this.userPreferencesPanelModel.declineChanges();
        MessageViewerPreferences messageViewerPreferences = bl ? this.messageViewerPreferencesPanelModel.acceptChanges() : this.messageViewerPreferencesPanelModel.declineChanges();
        ProxySettings proxySettings = bl ? this.proxySettingsPanelModel.acceptChanges() : this.proxySettingsPanelModel.declineChanges();
        PersonalData personalData = bl ? this.personalDataModel.acceptChanges() : this.personalDataModel.declineChanges();
        UserData userData = ApplicationContext.getInstance().getUserData();
        UserPreferences userPreferences2 = userData.getPreferences();
        MessageViewerPreferences messageViewerPreferences2 = userData.getMessageViewerPreferences();
        userData.setProxySettings(proxySettings);
        userData.setPreferences(new UserPreferences(userPreferences));
        userData.setPersonalData(personalData);
        userData.setMessageViewerPreferences(messageViewerPreferences);
        boolean bl3 = userPreferences2.getEntryPointUsed() != userPreferences.getEntryPointUsed();
        boolean bl4 = bl2 = userPreferences2.getLanguageCode() != userPreferences.getLanguageCode();
        if (!messageViewerPreferences2.equals(messageViewerPreferences)) {
            MessageViewer.Viewer.preferencesChanged(messageViewerPreferences);
        }
        if (bl2) {
            ApplicationContext.getInstance().loadI18NData(userPreferences.getLanguageCode());
            new ExtensionLoader().loadBundleData(ExtensionProvider.Provider.getExtensions());
            this.entryPointMediator.changeEntryPoint(userPreferences.getEntryPointUsed());
            bl3 = false;
        }
        if (bl3) {
            this.entryPointMediator.changeEntryPoint(userPreferences.getEntryPointUsed());
        }
        for (ExtensionInfo extensionInfo : ExtensionProvider.Provider.getExtensions()) {
            ExtensionSettings extensionSettings = extensionInfo.getExtension().settings();
            if (extensionSettings == null) continue;
            try {
                if (bl) {
                    extensionSettings.apply();
                    continue;
                }
                extensionSettings.cancel();
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Unable to process extension configuration for extension [" + extensionInfo.getName() + "]", exception);
            }
        }
        PostalAddresseeCache.Instance.updatePersonal(personalData.getPersonIdentity().toString(), userData.getAccounts());
        ProxyDispatcher.getDispatcher().setProxySettings(proxySettings);
    }

    public synchronized void writeSettings() {
        CommandExecutionService.Service.executeCommandSilent(new SaveSettingsCommand());
    }

    public void exportSettings() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setSelectedFile(new File(System.getProperty("user.home")));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showSaveDialog((Component)((Object)this.settingsDialog));
        if (n != 0) {
            return;
        }
        CommandExecutionService.Service.executeRegister(new NotificationBlockUITask(new ExportSettingsCommand(jFileChooser.getSelectedFile()), (Window)((Object)this.settingsDialog)));
    }

    public void importSettings() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setSelectedFile(new File(System.getProperty("user.home")));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith("zip");
            }

            @Override
            public String getDescription() {
                return "*.zip";
            }
        });
        int n = jFileChooser.showOpenDialog((Component)((Object)this.settingsDialog));
        if (n != 0) {
            return;
        }
        NotificationBlockUITask notificationBlockUITask = new NotificationBlockUITask(new ImportSettingsCommand(jFileChooser.getSelectedFile()), (Window)((Object)this.settingsDialog));
        notificationBlockUITask.addCommandExecutionListener(new CommandExecutionListener<Void>(){

            @Override
            public void beforeExecution(CommandExecutable<Void> commandExecutable) {
            }

            @Override
            public void afterExecution(CommandExecutable<Void> commandExecutable) {
                if (!commandExecutable.isExecutionPerformed() || commandExecutable.isErrorOccured()) {
                    return;
                }
                ApplicationContext applicationContext = ApplicationContext.getInstance();
                UserData userData = applicationContext.getUserData();
                SettingsMediator.this.messageViewerPreferencesPanelModel.fireModelUpdate(userData.getMessageViewerPreferences());
                SettingsMediator.this.userPreferencesPanelModel.fireModelUpdate(userData.getPreferences());
                SettingsMediator.this.proxySettingsPanelModel.fireModelUpdate(userData.getProxySettings());
                SettingsMediator.this.personalDataModel.fireModelUpdate(userData.getPersonalData());
                SettingsMediator.this.accountListMediator.fireModelUpdate();
                SettingsMediator.this.settingsDialog.changeApplyState(false);
            }
        });
        CommandExecutionService.Service.execute(notificationBlockUITask);
    }

    void changeApplyState(boolean bl) {
        this.settingsDialog.changeApplyState(bl);
    }

    public SettingsDialog getSettingsDialog() {
        return this.settingsDialog;
    }

    public AccountListMediator getAccountListMediator() {
        return this.accountListMediator;
    }

    public SignatureMediator getSignatureMediator() {
        return this.signatureMediator;
    }

    public AccountInfoMediator getAccountInfoMediator() {
        return this.accountInfoMediator;
    }

    public PersonalDataPanelModel getPersonalDataModel() {
        return this.personalDataModel;
    }

    public SettingsPanelModel getSettingsPanelModel() {
        return this.settingsPanelModel;
    }

    public ProxySettingsPanelModel getProxySettingsPanelModel() {
        return this.proxySettingsPanelModel;
    }

    public ExtensionsPanelModel getExtensionsPanelModel() {
        return this.extensionsPanelModel;
    }
}

