/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings;

import javax.swing.JFrame;
import net.sf.amemailchecker.app.model.PersonSignature;
import net.sf.amemailchecker.app.model.ui.PersonalSignaturePanelModel;
import net.sf.amemailchecker.gui.component.list.CheckedValueListModel;
import net.sf.amemailchecker.gui.settings.PersonalDataPanelModel;
import net.sf.amemailchecker.gui.settings.SettingsMediator;
import net.sf.amemailchecker.gui.settings.SignatureEditDialog;

public class SignatureMediator {
    private PersonalSignaturePanelModel currentSignatureModel;
    private SettingsMediator delegate;

    public SignatureMediator(SettingsMediator settingsMediator) {
        this.delegate = settingsMediator;
    }

    void createSignature() {
        this.currentSignatureModel = new PersonalSignaturePanelModel(new PersonSignature());
        this.openDialog(this.currentSignatureModel);
    }

    void acceptSignatureModify() {
        PersonalDataPanelModel personalDataPanelModel = this.delegate.getPersonalDataModel();
        CheckedValueListModel<PersonSignature> checkedValueListModel = personalDataPanelModel.getSignatureListModel();
        PersonSignature personSignature = this.currentSignatureModel.acceptChanges();
        if (personalDataPanelModel.getSignatureModel(personSignature.getUuid()) == null) {
            checkedValueListModel.addElement((Object)personSignature, false);
        }
        personalDataPanelModel.addSignatureModel(personSignature.getUuid(), this.currentSignatureModel);
        this.currentSignatureModel = null;
    }

    void editSignature(int n) {
        String string = ((PersonSignature)this.delegate.getPersonalDataModel().getSignatureListModel().getElementAt(n)).getUuid();
        this.currentSignatureModel = this.delegate.getPersonalDataModel().getSignatureModel(string);
        this.openDialog(this.currentSignatureModel);
    }

    void removeSignature(int n) {
        String string = ((PersonSignature)this.delegate.getPersonalDataModel().getSignatureListModel().getElementAt(n)).getUuid();
        this.delegate.getPersonalDataModel().removeSignatureModel(string);
        this.delegate.getPersonalDataModel().getSignatureListModel().removeElementAt(n);
    }

    private void openDialog(PersonalSignaturePanelModel personalSignaturePanelModel) {
        SignatureEditDialog signatureEditDialog = new SignatureEditDialog((JFrame)((Object)this.delegate.getSettingsDialog()), personalSignaturePanelModel);
        signatureEditDialog.setMediator(this);
        signatureEditDialog.init();
        signatureEditDialog.setVisible(true);
    }
}

