/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings.accounts;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.gui.component.list.DefaultHistoryListModel;
import net.sf.amemailchecker.gui.component.list.HistoryListCellRenderer;
import net.sf.amemailchecker.gui.component.list.HistoryListModel;
import net.sf.amemailchecker.gui.component.list.HistoryListModelObservable;
import net.sf.amemailchecker.gui.settings.accounts.AccountListMediator;
import net.sf.amemailchecker.gui.settings.accounts.AccountListMenu;
import net.sf.amemailchecker.mail.model.Account;

public class AccountList
extends JList {
    AccountListMediator mediator;
    private HistoryListModelObservable<Account> modelObservable;
    private HistoryListModel<Account> model;
    private AccountListMenu menu;

    public AccountList(AccountListMediator accountListMediator) {
        this.mediator = accountListMediator;
        accountListMediator.setAccountList(this);
    }

    public void init() {
        this.model = new DefaultHistoryListModel();
        for (Account account : ApplicationContext.getInstance().getUserData().getAccounts()) {
            this.model.insertElement((Object)account, account.isActive());
        }
        this.setModel(this.model);
        this.modelObservable = new HistoryListModelObservable(this.model);
        this.modelObservable.addObserver((Observer)ApplicationContext.getInstance().getAccountsCache());
        this.setSelectionMode(0);
        this.addMouseListener(new AccountListMouseListener());
        this.setCellRenderer(new AccountListRenderer());
        this.menu = new AccountListMenu(this.mediator);
    }

    public HistoryListModel<Account> getModel() {
        return this.model;
    }

    public HistoryListModelObservable<Account> getModelObservable() {
        return this.modelObservable;
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip jToolTip = super.createToolTip();
        jToolTip.setBackground(Color.WHITE);
        jToolTip.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLUE), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return jToolTip;
    }

    private class AccountListMouseListener
    extends MouseAdapter {
        private AccountListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                AccountList.this.mediator.editAccountInfo();
            }
            if (mouseEvent.getButton() == 3) {
                AccountList.this.menu.checkState();
                JPopupMenu jPopupMenu = AccountList.this.menu.getPopupMenu();
                jPopupMenu.setInvoker((JList)mouseEvent.getSource());
                jPopupMenu.setLocation(mouseEvent.getLocationOnScreen());
                jPopupMenu.setVisible(true);
            }
        }
    }

    private class AccountListRenderer
    extends HistoryListCellRenderer {
        private ResourceContext bundle = ApplicationContext.getInstance();

        private AccountListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            HistoryListModel historyListModel = (HistoryListModel)jList.getModel();
            this.setToolTipText(((Account)historyListModel.getElementAt(n)).getEmailAddress() + " (" + (historyListModel.isActive(n) ? this.bundle.getI18NBundleValue("label.enabled") : this.bundle.getI18NBundleValue("label.disabled")) + ")");
            return this;
        }
    }
}

