/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings.accounts;

import java.awt.Window;
import java.util.Collection;
import java.util.UUID;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.account.AccountBean;
import net.sf.amemailchecker.app.account.AccountServerBean;
import net.sf.amemailchecker.app.notification.NotificationCache;
import net.sf.amemailchecker.gui.component.list.HistoryListModel;
import net.sf.amemailchecker.gui.component.list.HistoryListModelObservable;
import net.sf.amemailchecker.gui.settings.SettingsMediator;
import net.sf.amemailchecker.gui.settings.accounts.AccountList;
import net.sf.amemailchecker.mail.cache.PostalAddresseeCache;
import net.sf.amemailchecker.mail.impl.mailbox.MailBoxImpl;
import net.sf.amemailchecker.mail.model.Account;
import net.sf.amemailchecker.mail.model.MailBoxPreferences;

public class AccountListMediator {
    private SettingsMediator delegate;
    private AccountList accountList;

    public AccountListMediator(SettingsMediator settingsMediator) {
        this.delegate = settingsMediator;
    }

    void testConnection(AccountBean accountBean, AccountServerBean accountServerBean) {
        this.delegate.getAccountInfoMediator().testConnection((Window)((Object)this.delegate.getSettingsDialog()), accountBean, accountServerBean);
    }

    public void testConnectionOut() {
        AccountBean accountBean = this.getAccountInfoSelected(true);
        this.testConnection(accountBean, accountBean.getOutgoingServer());
    }

    public void testConnectionIn() {
        AccountBean accountBean = this.getAccountInfoSelected(true);
        this.testConnection(accountBean, accountBean.getIngoingServer());
    }

    public void invalidateSelected() {
        this.accountList.getModel().invalidate(this.accountList.getSelectedIndex());
    }

    public boolean isElementChanged() {
        return this.accountList.getModel().isChanged(this.accountList.getSelectedIndex());
    }

    public boolean isChanged() {
        return this.accountList.getModel().isChanged();
    }

    public void invalidateModel() {
        this.accountList.getModel().invalidate();
    }

    public void setElementActive() {
        this.accountList.getModel().setActive(this.accountList.getSelectedIndex());
    }

    public boolean isActiveElement() {
        return this.accountList.getModel().isActive(this.accountList.getSelectedIndex());
    }

    public void createAccountInfo() {
        this.delegate.getAccountInfoMediator().createAccountInfo();
    }

    public void editAccountInfo() {
        this.delegate.getAccountInfoMediator().editAccountInfo();
    }

    public void deleteElement() {
        int n = this.accountList.getSelectedIndex();
        NotificationCache.getInstance().remove(((Account)this.accountList.getModel().getElementAt(n)).getUuid());
        this.accountList.getModel().setDeletedElement(n);
    }

    public AccountBean getAccountInfoSelected(boolean bl) {
        if (!bl) {
            this.accountList.clearSelection();
        }
        if (bl) {
            return new AccountBean((AccountBean)this.accountList.getModel().getElementAt(this.accountList.getSelectedIndex()));
        }
        AccountBean accountBean = new AccountBean(UUID.randomUUID().toString());
        accountBean.setMailBox(new MailBoxImpl());
        accountBean.setMailBoxPreferences(new MailBoxPreferences());
        return accountBean;
    }

    public void acceptUpdates() {
        HistoryListModelObservable<Account> historyListModelObservable = this.accountList.getModelObservable();
        Collection collection = historyListModelObservable.getOrigins();
        for (Account account : collection) {
            PostalAddresseeCache.Instance.remove(account.getEmailAddress());
        }
        historyListModelObservable.fireObserverUpdate();
    }

    public void declineUpdates() {
        ApplicationContext.getInstance().getAccountsCache().setAccounts(this.accountList.getModelObservable().getOrigins());
    }

    public void fireModelUpdate() {
        HistoryListModel<Account> historyListModel = this.accountList.getModel();
        historyListModel.clearOrigins();
        for (Account account : ApplicationContext.getInstance().getUserData().getAccounts()) {
            historyListModel.insertElement((Object)account, account.isActive());
        }
    }

    public void changeAccountInfo(AccountBean accountBean) {
        this.accountList.getModel().setEditedElement((Object)accountBean, this.accountList.getSelectedIndex());
    }

    public void setAccountList(AccountList accountList) {
        this.accountList = accountList;
    }

    public AccountList getAccountList() {
        return this.accountList;
    }
}

