/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings.accounts;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.ResourceContext;
import net.sf.amemailchecker.gui.settings.accounts.AccountListMediator;

public class AccountListMenu
extends JMenu {
    private AccountListMediator mediator;
    private ResourceContext bundle;
    private JMenuItem create;
    private JMenuItem edit;
    private JMenuItem delete;
    private JMenuItem activate;
    private JMenuItem testConnectionIn;
    private JMenuItem testConnectionOut;
    private JMenuItem revert;
    private JMenuItem revertAll;
    private JMenu revertMenu;
    private JMenu testConnectionMenu;

    public AccountListMenu(AccountListMediator accountListMediator) {
        this.mediator = accountListMediator;
        this.init();
    }

    public AccountListMenu(String string, AccountListMediator accountListMediator) {
        this(accountListMediator);
        this.setText(string);
    }

    @Override
    public void setPopupMenuVisible(boolean bl) {
        this.checkState();
        super.setPopupMenuVisible(bl);
    }

    public void checkState() {
        this.setEnabled(this.mediator.getAccountList().getSelectedIndex() != -1);
    }

    public void init() {
        this.bundle = ApplicationContext.getInstance();
        this.create = new JMenuItem(this.bundle.getI18NBundleValue("action.new.label"));
        this.create.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountListMenu.this.mediator.createAccountInfo();
            }
        });
        this.edit = new JMenuItem(this.bundle.getI18NBundleValue("action.edit.label"));
        this.edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountListMenu.this.mediator.editAccountInfo();
            }
        });
        this.delete = new JMenuItem(this.bundle.getI18NBundleValue("action.delete.label"));
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountListMenu.this.mediator.deleteElement();
            }
        });
        this.activate = new JMenuItem();
        this.activate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountListMenu.this.mediator.setElementActive();
            }
        });
        this.testConnectionIn = new JMenuItem(this.bundle.getI18NBundleValue("label.server.in"));
        this.testConnectionIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountListMenu.this.mediator.testConnectionIn();
            }
        });
        this.testConnectionOut = new JMenuItem(this.bundle.getI18NBundleValue("label.server.out"));
        this.testConnectionOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountListMenu.this.mediator.testConnectionOut();
            }
        });
        this.revert = new JMenuItem(this.bundle.getI18NBundleValue("action.revert.label"));
        this.revert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountListMenu.this.mediator.invalidateSelected();
            }
        });
        this.revertAll = new JMenuItem(this.bundle.getI18NBundleValue("action.revert.all.label"));
        this.revertAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccountListMenu.this.mediator.invalidateModel();
            }
        });
        this.revertMenu = new JMenu(this.bundle.getI18NBundleValue("action.revert.label"));
        this.revertMenu.add(this.revertAll);
        this.testConnectionMenu = new JMenu(this.bundle.getI18NBundleValue("action.test.label"));
        this.testConnectionMenu.add(this.testConnectionIn);
        this.testConnectionMenu.add(this.testConnectionOut);
        this.add(this.create);
        this.add(this.edit);
        this.add(this.delete);
        this.add(new JSeparator());
        this.add(this.testConnectionMenu);
        this.add(this.revertMenu);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.edit.setEnabled(bl);
        this.delete.setEnabled(bl);
        this.testConnectionMenu.setEnabled(bl);
        this.revertAll.setEnabled(this.mediator.isChanged());
        this.proccessActivate(bl);
    }

    public void proccessActivate(boolean bl) {
        if (bl) {
            this.activate.setText(this.mediator.isActiveElement() ? this.bundle.getI18NBundleValue("action.deactivate.label") : this.bundle.getI18NBundleValue("action.activate.label"));
            this.add(this.activate);
            this.revert.setEnabled(this.mediator.isElementChanged());
            this.revertMenu.add(this.revert);
        } else {
            this.remove(this.activate);
            this.revertMenu.remove(this.revert);
        }
    }
}

