/*
 * Decompiled with CFR 0.152.
 */
package net.sf.amemailchecker.gui.settings.preferences;

import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.sf.amemailchecker.app.ApplicationContext;
import net.sf.amemailchecker.app.LookAndFeelManager;
import net.sf.amemailchecker.app.model.Language;
import net.sf.amemailchecker.app.model.UIPanelModel;
import net.sf.amemailchecker.app.model.UserPreferences;
import net.sf.amemailchecker.app.model.ValueIDComboModel;
import net.sf.amemailchecker.gui.component.chooser.AlignmentChooserModel;
import net.sf.amemailchecker.gui.component.chooser.DefaultAlignmentChooserModel;
import net.sf.amemailchecker.gui.entrypoint.EntryPointType;
import net.sf.amemailchecker.gui.notification.NotificationType;
import net.sf.amemailchecker.gui.notification.window.desktop.slidein.AnimatingType;

public class UserPreferencesPanelModel
implements UIPanelModel<UserPreferences> {
    private SpinnerNumberModel checkIntervalModel;
    private SpinnerNumberModel notificationDelayModel;
    private ValueIDComboModel<Integer> entrySelectionModel;
    private ValueIDComboModel<Integer> notificationTypeSelectionModel;
    private ValueIDComboModel<Integer> languageModel;
    private ValueIDComboModel<Integer> notificationAnimatingTypeModel;
    private JToggleButton.ToggleButtonModel emptyCacheAccountInactiveModel;
    private AlignmentChooserModel notificationAlignmentModel;
    private ValueIDComboModel<Integer> lookSelectionModel;
    private PlainDocument downloadsDirPathModel;
    private UserPreferences userPreferences;
    private UserPreferences userPreferencesOrig;

    public UserPreferencesPanelModel(UserPreferences userPreferences) {
        ApplicationContext applicationContext = ApplicationContext.getInstance();
        this.notificationDelayModel = new SpinnerNumberModel(0, 0, 60, 1);
        this.checkIntervalModel = new SpinnerNumberModel(5, 5, 60, 1);
        this.entrySelectionModel = new ValueIDComboModel();
        this.entrySelectionModel.addElement((Object)EntryPointType.TRAY_ICON.getId(), applicationContext.getI18NBundleValue(EntryPointType.TRAY_ICON.getTitleKey()));
        this.entrySelectionModel.addElement((Object)EntryPointType.DOCKLET.getId(), applicationContext.getI18NBundleValue(EntryPointType.DOCKLET.getTitleKey()));
        this.notificationTypeSelectionModel = new ValueIDComboModel();
        this.notificationTypeSelectionModel.addElement((Object)NotificationType.SIMPLE.getId(), applicationContext.getI18NBundleValue("label.notify.simple"));
        this.notificationTypeSelectionModel.addElement((Object)NotificationType.DETAILED.getId(), applicationContext.getI18NBundleValue("label.notify.detailed"));
        this.languageModel = new ValueIDComboModel();
        for (Language language : ApplicationContext.getInstance().getSettings().getLanguageData()) {
            this.languageModel.addElement((Object)language.getCode(), language.getLabel());
        }
        this.notificationAnimatingTypeModel = new ValueIDComboModel();
        this.notificationAnimatingTypeModel.addElement((Object)AnimatingType.SLIDE_BOTTOM.getId(), applicationContext.getI18NBundleValue("label.slide.bottom"));
        this.notificationAnimatingTypeModel.addElement((Object)AnimatingType.SLIDE_TOP.getId(), applicationContext.getI18NBundleValue("label.slide.top"));
        this.notificationAnimatingTypeModel.addElement((Object)AnimatingType.SLIDE_LEFT.getId(), applicationContext.getI18NBundleValue("label.slide.left"));
        this.notificationAnimatingTypeModel.addElement((Object)AnimatingType.SLIDE_RIGHT.getId(), applicationContext.getI18NBundleValue("label.slide.right"));
        this.notificationAlignmentModel = new DefaultAlignmentChooserModel();
        this.emptyCacheAccountInactiveModel = new JToggleButton.ToggleButtonModel();
        this.lookSelectionModel = new ValueIDComboModel();
        this.lookSelectionModel.addElement((Object)LookAndFeelManager.Look.DEFAULT.getId(), applicationContext.getI18NBundleValue(LookAndFeelManager.Look.DEFAULT.getTitleKey()));
        this.lookSelectionModel.addElement((Object)LookAndFeelManager.Look.CROSS_PLATFORM.getId(), applicationContext.getI18NBundleValue(LookAndFeelManager.Look.CROSS_PLATFORM.getTitleKey()));
        this.lookSelectionModel.addElement((Object)LookAndFeelManager.Look.NATIVE.getId(), applicationContext.getI18NBundleValue(LookAndFeelManager.Look.NATIVE.getTitleKey()));
        this.downloadsDirPathModel = new PlainDocument();
        this.fireModelUpdate(userPreferences);
    }

    public void fill() {
        this.notificationDelayModel.setValue(this.userPreferences.getNotificationDisplayDelay());
        this.checkIntervalModel.setValue(this.userPreferences.getMinCheckInterval());
        this.entrySelectionModel.setSelected((Object)this.userPreferences.getEntryPointUsed());
        this.notificationTypeSelectionModel.setSelected((Object)this.userPreferences.getNotificationTypeUsed());
        this.languageModel.setSelected((Object)this.userPreferences.getLanguageCode());
        this.notificationAnimatingTypeModel.setSelected((Object)this.userPreferences.getNotificationAnimatingType());
        this.notificationAlignmentModel.setAlignmentX(this.userPreferences.getNotificationAlignmentX());
        this.notificationAlignmentModel.setAlignmentY(this.userPreferences.getNotificationAlignmentY());
        this.emptyCacheAccountInactiveModel.setSelected(this.userPreferences.isEmptyCacheAccountInactive());
        this.lookSelectionModel.setSelected((Object)this.userPreferences.getLook());
        try {
            this.downloadsDirPathModel.remove(0, this.downloadsDirPathModel.getLength());
            this.downloadsDirPathModel.insertString(0, this.userPreferences.getDownloadsDirPath(), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public UserPreferences acceptChanges() {
        this.userPreferences.setMinCheckInterval((Integer)this.checkIntervalModel.getValue());
        this.userPreferences.setNotificationDisplayDelay((Integer)this.notificationDelayModel.getValue());
        this.userPreferences.setEntryPointUsed((Integer)this.entrySelectionModel.getSelected());
        this.userPreferences.setNotificationTypeUsed((Integer)this.notificationTypeSelectionModel.getSelected());
        this.userPreferences.setLanguageCode((Integer)this.languageModel.getSelected());
        this.userPreferences.setNotificationAnimatingType((Integer)this.notificationAnimatingTypeModel.getSelected());
        this.userPreferences.setNotificationAlignmentX(this.notificationAlignmentModel.getAlignmentX());
        this.userPreferences.setNotificationAlignmentY(this.notificationAlignmentModel.getAlignmentY());
        this.userPreferences.setEmptyCacheAccountInactive(this.emptyCacheAccountInactiveModel.isSelected());
        this.userPreferences.setLook((Integer)this.lookSelectionModel.getSelected());
        try {
            this.userPreferences.setDownloadsDirPath(this.downloadsDirPathModel.getText(0, this.downloadsDirPathModel.getLength()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return this.userPreferences;
    }

    public UserPreferences declineChanges() {
        return this.userPreferencesOrig;
    }

    public void fireModelUpdate(UserPreferences userPreferences) {
        this.userPreferences = new UserPreferences(userPreferences);
        this.userPreferencesOrig = userPreferences;
        this.fill();
    }

    SpinnerNumberModel getCheckIntervalModel() {
        return this.checkIntervalModel;
    }

    SpinnerNumberModel getNotificationDelayModel() {
        return this.notificationDelayModel;
    }

    ValueIDComboModel getEntrySelectionModel() {
        return this.entrySelectionModel;
    }

    ValueIDComboModel getNotificationTypeSelectionModel() {
        return this.notificationTypeSelectionModel;
    }

    ValueIDComboModel getLanguageModel() {
        return this.languageModel;
    }

    ValueIDComboModel getNotificationAnimatingTypeModel() {
        return this.notificationAnimatingTypeModel;
    }

    AlignmentChooserModel getNotificationAlignmentModel() {
        return this.notificationAlignmentModel;
    }

    JToggleButton.ToggleButtonModel getEmptyCacheAccountInactiveModel() {
        return this.emptyCacheAccountInactiveModel;
    }

    ValueIDComboModel<Integer> getLookSelectionModel() {
        return this.lookSelectionModel;
    }

    PlainDocument getDownloadsDirPathModel() {
        return this.downloadsDirPathModel;
    }
}

